/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SplashScreen
extends Canvas
implements CommandListener {
    private final pacman midlet;
    private final Command exitCommand;
    private int x;
    private int y = 40;
    private int pacDirection = 1;
    private int mouthAngle = 320;
    private int mouthAngleChange = 10;
    private int mouthAngleDirection = 20;
    private SplashTrigger splashTrigger;
    private Random generator = new Random();

    public SplashScreen(pacman pacman2) {
        this.midlet = pacman2;
        this.exitCommand = new Command("Next", 7, 1);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        this.splashTrigger = new SplashTrigger(this, 20);
        this.splashTrigger.start();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 120);
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        graphics.drawString("PacMan", 25, 5, 20);
        this.animateScene(graphics);
    }

    public void animateScene(Graphics graphics) {
        if (this.mouthAngle <= 300) {
            this.mouthAngleChange = 10;
        }
        if (this.mouthAngle >= 360) {
            this.mouthAngleChange = -10;
        }
        this.mouthAngle += this.mouthAngleChange;
        this.mouthAngleDirection -= this.mouthAngleChange;
        graphics.setColor(0, 0, 0);
        graphics.fillArc(this.x, this.y, 8, 8, this.mouthAngleDirection, this.mouthAngle);
        graphics.drawArc(this.x - 30, this.y, 8, 8, 0, 360);
        graphics.drawArc(this.x - 50, this.y, 8, 8, 0, 360);
        graphics.drawArc(this.x - 70, this.y, 8, 8, 0, 360);
    }

    public void advanceFrame() {
        this.x += this.pacDirection * 1;
        if (this.x == 180) {
            this.pacDirection = -1;
            this.mouthAngleDirection = 210;
            this.y = Math.abs(this.generator.nextInt() % 40) + 25;
        }
        if (this.x == -30) {
            this.pacDirection = 1;
            this.mouthAngleDirection = 20;
            this.y = Math.abs(this.generator.nextInt() % 40) + 25;
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.splashTrigger.stopTrigger();
            this.midlet.splashScreenDone();
        }
    }
}

