/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;

public class PacmanActor {
    public static final int NONE = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private GridNode myNode_;
    private int pelletsEaten_;
    public int score_;
    public boolean invincible_;
    private int pixelX_;
    private int pixelY_;
    private int newPixelX_;
    private int newPixelY_;
    private int direction_;
    private int animDirection_ = 4;
    private GridNode startNode_;
    private int mouthAngle_;
    private int mouthAngleChange_;
    private int mouthAngleDirection_;
    public int myLivesLeft_;
    private PacmanTimer invincibleTimer;

    public PacmanActor(GridNode gridNode) {
        this.myNode_ = gridNode;
        this.startNode_ = gridNode;
        this.invincible_ = false;
        this.pixelX_ = this.myNode_.pixelCenterX();
        this.pixelY_ = this.myNode_.pixelCenterY();
        this.newPixelX_ = this.pixelX_;
        this.newPixelY_ = this.pixelY_;
        this.direction_ = 0;
        this.pelletsEaten_ = 0;
        this.mouthAngleDirection_ = 20;
        this.mouthAngle_ = 320;
        this.mouthAngleChange_ = 10;
        this.myLivesLeft_ = 2;
    }

    public GridNode getNode() {
        return this.myNode_;
    }

    public int getPelletsEaten() {
        return this.pelletsEaten_;
    }

    public int getX() {
        return this.pixelX_;
    }

    public int getY() {
        return this.pixelY_;
    }

    public int getLivesLeft() {
        return this.myLivesLeft_;
    }

    public void setDesiredDirection(int n) {
        this.direction_ = n;
    }

    public void setLivesLeft(int n) {
        this.myLivesLeft_ = n;
    }

    private void goToNode(GridNode gridNode) {
        if (gridNode == null) {
            return;
        }
        this.myNode_ = gridNode;
        this.newPixelX_ = this.myNode_.pixelCenterX();
        this.newPixelY_ = this.myNode_.pixelCenterY();
    }

    public boolean isInvincible() {
        return this.invincible_;
    }

    public void restart() {
        this.myNode_ = this.startNode_;
        this.pixelX_ = this.startNode_.pixelCenterX();
        this.pixelY_ = this.startNode_.pixelCenterY();
        this.newPixelX_ = this.startNode_.pixelCenterX();
        this.newPixelY_ = this.startNode_.pixelCenterY();
        this.invincible_ = false;
        this.direction_ = 0;
        this.animDirection_ = 4;
        this.pelletsEaten_ = this.pelletsEaten_;
        this.mouthAngleDirection_ = 20;
        this.mouthAngle_ = 320;
        this.mouthAngleChange_ = 10;
        --this.myLivesLeft_;
    }

    public void advanceFrame() {
        if (this.pixelX_ != this.newPixelX_ || this.pixelY_ != this.newPixelY_) {
            if (this.pixelX_ < this.newPixelX_) {
                ++this.pixelX_;
            }
            if (this.pixelX_ > this.newPixelX_) {
                --this.pixelX_;
            }
            if (this.pixelY_ < this.newPixelY_) {
                ++this.pixelY_;
            }
            if (this.pixelY_ > this.newPixelY_) {
                --this.pixelY_;
            }
        } else {
            if (this.myNode_.getPellet() == 1) {
                this.myNode_.setPellet(0);
                ++this.pelletsEaten_;
                ++this.score_;
            } else if (this.myNode_.getPellet() == 2) {
                this.myNode_.setPellet(0);
                this.pelletsEaten_ += 2;
                this.score_ += 2;
                this.invincibleTimer = new PacmanTimer();
            }
            if (this.direction_ == 3) {
                this.goToNode(this.myNode_.getLeft());
                this.animDirection_ = 3;
            }
            if (this.direction_ == 4) {
                this.goToNode(this.myNode_.getRight());
                this.animDirection_ = 4;
            }
            if (this.direction_ == 2) {
                this.goToNode(this.myNode_.getDown());
                this.animDirection_ = 2;
            }
            if (this.direction_ == 1) {
                this.goToNode(this.myNode_.getUp());
                this.animDirection_ = 1;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.mouthAngle_ <= 300) {
            this.mouthAngleChange_ = 10;
        }
        if (this.mouthAngle_ >= 360) {
            this.mouthAngleChange_ = -10;
        }
        this.mouthAngle_ += this.mouthAngleChange_;
        switch (this.animDirection_) {
            case 4: {
                this.mouthAngleDirection_ = 30;
                break;
            }
            case 3: {
                this.mouthAngleDirection_ = 210;
                break;
            }
            case 1: {
                this.mouthAngleDirection_ = 120;
                break;
            }
            case 2: {
                this.mouthAngleDirection_ = 300;
                break;
            }
        }
        this.mouthAngleDirection_ -= this.mouthAngleChange_;
        graphics.setColor(0, 0, 0);
        graphics.fillArc(this.pixelX_ - 4, this.pixelY_ - 4, 8, 8, this.mouthAngleDirection_, this.mouthAngle_);
    }

    public class PacmanTimer {
        Timer timer;

        public PacmanTimer() {
            PacmanActor.this.invincible_ = true;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new PacmanTask(), 6000L);
        }

        class PacmanTask
        extends TimerTask {
            PacmanTask() {
            }

            public void run() {
                System.out.println("Time's up!");
                PacmanTimer.this.timer.cancel();
                ((PacmanTimer)PacmanTimer.this).PacmanActor.this.invincible_ = false;
            }
        }
    }
}

