/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GridNode {
    public static final int NO_PELLET = 0;
    public static final int SMALL_PELLET = 1;
    public static final int BIG_PELLET = 2;
    private static int size_;
    private int pellet_;
    private GridNode left_;
    private GridNode right_;
    private GridNode up_;
    private GridNode down_;
    private int posX_;
    private int posY_;
    private int pixelULX_;
    private int pixelULY_;
    private int pixelLRX_;
    private int pixelLRY_;
    private int pixelCX_;
    private int pixelCY_;

    public static void setSize(int n) {
        size_ = n;
    }

    public static int getSize() {
        return size_;
    }

    public GridNode(int n, int n2) {
        this.posX_ = n;
        this.posY_ = n2;
        this.left_ = null;
        this.right_ = null;
        this.up_ = null;
        this.down_ = null;
        this.pellet_ = 1;
        this.pixelULX_ = this.posX_ * size_;
        this.pixelULY_ = this.posY_ * size_;
        this.pixelLRX_ = this.pixelULX_ + size_ - 1;
        this.pixelLRY_ = this.pixelULY_ + size_ - 1;
        this.pixelCX_ = (this.pixelULX_ + this.pixelLRX_) / 2;
        this.pixelCY_ = (this.pixelULY_ + this.pixelLRY_) / 2;
    }

    public int pixelCenterX() {
        return this.pixelCX_;
    }

    public int pixelCenterY() {
        return this.pixelCY_;
    }

    public void setLeft(GridNode gridNode) {
        this.left_ = gridNode;
    }

    public void setRight(GridNode gridNode) {
        this.right_ = gridNode;
    }

    public void setUp(GridNode gridNode) {
        this.up_ = gridNode;
    }

    public void setDown(GridNode gridNode) {
        this.down_ = gridNode;
    }

    public GridNode getLeft() {
        return this.left_;
    }

    public GridNode getRight() {
        return this.right_;
    }

    public GridNode getUp() {
        return this.up_;
    }

    public GridNode getDown() {
        return this.down_;
    }

    public void setPellet(int n) {
        this.pellet_ = n;
    }

    public int getPellet() {
        return this.pellet_;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(this.pixelULX_, this.pixelULY_, this.pixelLRX_, this.pixelLRY_);
        graphics.setColor(0, 0, 0);
        if (this.left_ == null) {
            graphics.drawLine(this.pixelULX_, this.pixelULY_, this.pixelULX_, this.pixelLRY_);
        }
        if (this.right_ == null) {
            graphics.drawLine(this.pixelLRX_, this.pixelULY_, this.pixelLRX_, this.pixelLRY_);
        }
        if (this.up_ == null) {
            graphics.drawLine(this.pixelULX_, this.pixelULY_, this.pixelLRX_, this.pixelULY_);
        }
        if (this.down_ == null) {
            graphics.drawLine(this.pixelULX_, this.pixelLRY_, this.pixelLRX_, this.pixelLRY_);
        }
        int n = 0;
        if (this.pellet_ == 2) {
            n = size_ / 3;
        }
        if (this.pellet_ == 1) {
            n = size_ / 5;
        }
        if (this.pellet_ != 0) {
            graphics.fillArc(this.pixelCX_, this.pixelCY_, n, n, 0, 360);
        }
    }
}

