/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GhostActor {
    public static final int NONE = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private GridNode myNode_;
    private GridNode resetNode_;
    private PacmanActor target_;
    private int pixelX_;
    private int pixelY_;
    private int newPixelX_;
    private int newPixelY_;
    private static boolean runFromPac_;

    public GhostActor(GridNode gridNode, PacmanActor pacmanActor) {
        this.myNode_ = gridNode;
        this.resetNode_ = gridNode;
        this.target_ = pacmanActor;
        this.pixelX_ = this.myNode_.pixelCenterX();
        this.pixelY_ = this.myNode_.pixelCenterY();
        this.newPixelX_ = this.pixelX_;
        this.newPixelY_ = this.pixelY_;
    }

    public static void setRunFromPac(boolean bl) {
        runFromPac_ = bl;
    }

    public GridNode getNode() {
        return this.myNode_;
    }

    public void advanceFrame() {
        if (this.pixelX_ != this.newPixelX_ || this.pixelY_ != this.newPixelY_) {
            if (this.pixelX_ < this.newPixelX_) {
                ++this.pixelX_;
            }
            if (this.pixelX_ > this.newPixelX_) {
                --this.pixelX_;
            }
            if (this.pixelY_ < this.newPixelY_) {
                ++this.pixelY_;
            }
            if (this.pixelY_ > this.newPixelY_) {
                --this.pixelY_;
            }
        } else {
            int n = this.target_.getNode().pixelCenterX();
            int n2 = this.target_.getNode().pixelCenterY();
            System.out.println("(" + (n -= this.pixelX_) + "," + (n2 -= this.pixelY_) + ")");
            if (Math.abs(n) > Math.abs(n2)) {
                if (n > 0) {
                    this.moveTowards(4, 1, 2, 3);
                } else {
                    this.moveTowards(3, 2, 1, 4);
                }
            } else if (n2 > 0) {
                this.moveTowards(2, 3, 4, 2);
            } else {
                this.moveTowards(1, 4, 3, 1);
            }
        }
    }

    private void moveTowards(int n, int n2, int n3, int n4) {
        if (runFromPac_) {
            if (this.goInDirection(n4)) {
                return;
            }
            if (this.goInDirection(n3)) {
                return;
            }
            if (this.goInDirection(n2)) {
                return;
            }
            if (this.goInDirection(n)) {
                return;
            }
        } else {
            if (this.goInDirection(n)) {
                return;
            }
            if (this.goInDirection(n2)) {
                return;
            }
            if (this.goInDirection(n3)) {
                return;
            }
            if (this.goInDirection(n4)) {
                return;
            }
        }
    }

    private boolean goInDirection(int n) {
        if (n == 3) {
            return this.goToNode(this.myNode_.getLeft());
        }
        if (n == 4) {
            return this.goToNode(this.myNode_.getRight());
        }
        if (n == 1) {
            return this.goToNode(this.myNode_.getUp());
        }
        if (n == 2) {
            return this.goToNode(this.myNode_.getDown());
        }
        return false;
    }

    private boolean goToNode(GridNode gridNode) {
        if (gridNode == null) {
            return false;
        }
        this.myNode_ = gridNode;
        this.newPixelX_ = this.myNode_.pixelCenterX();
        this.newPixelY_ = this.myNode_.pixelCenterY();
        return true;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.drawArc(this.pixelX_ - 4, this.pixelY_ - 4, 8, 8, 0, 360);
    }

    public int getX() {
        return this.pixelX_;
    }

    public int getY() {
        return this.pixelY_;
    }

    public void restart() {
        this.myNode_ = this.resetNode_;
        this.pixelX_ = this.resetNode_.pixelCenterX();
        this.pixelY_ = this.resetNode_.pixelCenterY();
        this.newPixelX_ = this.pixelX_;
        this.newPixelY_ = this.pixelY_;
    }
}

