/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameBoard {
    public static final int ALIVE = 0;
    public static final int DEAD = 1;
    private Vector nodes_ = new Vector();
    private Vector ghosts_ = new Vector();
    public PacmanActor pacman_;
    private int state_ = 0;

    public void addGridNode(GridNode gridNode) {
        this.nodes_.addElement(gridNode);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.nodes_.size()) {
            GridNode gridNode = (GridNode)this.nodes_.elementAt(n);
            gridNode.paint(graphics);
            ++n;
        }
        this.pacman_.paint(graphics);
        int n2 = 0;
        while (n2 < this.ghosts_.size()) {
            GhostActor ghostActor = (GhostActor)this.ghosts_.elementAt(n2);
            ghostActor.paint(graphics);
            graphics.drawString(Integer.toString(this.pacman_.score_), 68, 65, 20);
            graphics.drawString(Integer.toString(this.pacman_.getLivesLeft()), 58, 65, 20);
            ++n2;
        }
    }

    public boolean advanceFrame() {
        int n = 0;
        while (n < this.ghosts_.size()) {
            GhostActor ghostActor = (GhostActor)this.ghosts_.elementAt(n);
            if (Math.abs(ghostActor.getX() - this.pacman_.getX()) < 3 && Math.abs(ghostActor.getY() - this.pacman_.getY()) < 3) {
                if (!this.pacman_.isInvincible()) {
                    this.state_ = 1;
                } else {
                    this.pacman_.score_ += 5;
                    ghostActor.restart();
                }
            }
            ghostActor.advanceFrame();
            ++n;
        }
        if (this.state_ == 1) {
            this.pacman_.restart();
            if (this.pacman_.getLivesLeft() < 0) {
                return false;
            }
            this.state_ = 0;
            int n2 = 0;
            while (n2 < this.ghosts_.size()) {
                GhostActor ghostActor = (GhostActor)this.ghosts_.elementAt(n2);
                ghostActor.restart();
                ++n2;
            }
        } else {
            this.pacman_.advanceFrame();
        }
        return true;
    }

    public void setPacman(PacmanActor pacmanActor) {
        this.pacman_ = pacmanActor;
    }

    public PacmanActor getPacman() {
        return this.pacman_;
    }

    public void addGhost(GhostActor ghostActor) {
        this.ghosts_.addElement(ghostActor);
    }
}

