/*
 * Decompiled with CFR 0.152.
 */
package JCaro;

import JCaro.JCaro;
import JCaro.Table;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameCanvas
extends Canvas
implements CommandListener {
    int userid = 1;
    int comid = 2;
    int NOTHING = 0;
    int PREPARE = 1;
    int KEYMOVE = 2;
    int DISPLAYRESULT = 3;
    int KEYENTER = 4;
    int DISPLAYHELP = 5;
    int REFRESH = 6;
    boolean userwin = true;
    int status = 0;
    int bannerwidth = 80;
    int bannerheight = 40;
    int bannerx = (this.getWidth() - this.bannerwidth) / 2;
    int bannery = this.getHeight() - this.bannerheight - 15;
    int size = 1;
    boolean humanfirst = true;
    Command cmdSize;
    Command cmdLevel;
    Command cmdFirst;
    Command cmdHelp;
    Command cmdReturn;
    int m;
    int n;
    int d = this.getWidth() / 14;
    int ox;
    int oy;
    int x;
    int y;
    int xc;
    int yc;
    int xold;
    int yold;
    Table table = new Table();
    int drawX;
    int drawY;
    int drawStatus;
    int backcolor = 0xFFFFFF;
    int bordercolor = 0x969696;
    int selectcolor = 13754970;

    public GameCanvas() {
        try {
            this.setCommandListener(this);
            this.addCommand(new Command("Exit", 7, 1));
            this.addMenu();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.update(this.PREPARE);
    }

    private void addMenu() {
        if (this.size == 0) {
            this.cmdSize = new Command("Size : Small", 4, 1);
        } else if (this.size == 1) {
            this.cmdSize = new Command("Size : Standard", 4, 1);
        } else if (this.size == 2) {
            this.cmdSize = new Command("Size : Large", 4, 1);
        }
        this.addCommand(this.cmdSize);
        if (this.table.level == 0) {
            this.cmdLevel = new Command("Level : Easy", 4, 2);
        } else if (this.table.level == 1) {
            this.cmdLevel = new Command("Level : Normal", 4, 2);
        } else if (this.table.level == 2) {
            this.cmdLevel = new Command("Level : Hard", 4, 2);
        }
        this.addCommand(this.cmdLevel);
        this.cmdFirst = this.humanfirst ? new Command("First : You", 4, 3) : new Command("First : Computer", 4, 3);
        this.addCommand(this.cmdFirst);
        this.cmdHelp = new Command("Help", 4, 4);
        this.cmdReturn = new Command("Return", 4, 5);
        this.addCommand(this.cmdHelp);
        this.addCommand(this.cmdReturn);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            JCaro.quitApp();
        } else if (command.getCommandType() == 4) {
            if (command.getPriority() == 1) {
                this.size = (this.size + 1) % 3;
                if (this.size == 0) {
                    this.d = this.getWidth() / 10;
                } else if (this.size == 1) {
                    this.d = this.getWidth() / 14;
                } else if (this.size == 2) {
                    this.d = this.getWidth() / 18;
                }
            } else if (command.getPriority() == 2) {
                this.table.level = (this.table.level + 1) % 3;
            } else if (command.getPriority() == 3) {
                this.humanfirst = !this.humanfirst;
            } else {
                if (command.getPriority() == 4) {
                    this.update(this.DISPLAYHELP);
                    return;
                }
                this.update(this.REFRESH);
                return;
            }
            this.update(this.PREPARE);
            this.removeCommand(this.cmdSize);
            this.removeCommand(this.cmdLevel);
            this.removeCommand(this.cmdFirst);
            this.removeCommand(this.cmdHelp);
            this.removeCommand(this.cmdReturn);
            this.addMenu();
        }
    }

    public void drawCell(Graphics graphics, int n, int n2, int n3) {
        if (n3 == 0) {
            graphics.setColor(this.backcolor);
        } else {
            graphics.setColor(this.selectcolor);
        }
        graphics.fillRect(this.ox + n * this.d, this.oy + n2 * this.d, this.d, this.d);
        graphics.setColor(this.bordercolor);
        graphics.drawRect(this.ox + n * this.d, this.oy + n2 * this.d, this.d, this.d);
        if (n >= 0 && n2 >= 0 && n < this.m && n2 < this.n) {
            if (this.table.cell[n][n2] == 1) {
                graphics.setColor(255, 0, 0);
                graphics.drawLine(this.ox + n * this.d + 2, this.oy + n2 * this.d + 2, this.ox + (n + 1) * this.d - 2, this.oy + (n2 + 1) * this.d - 2);
                graphics.drawLine(this.ox + n * this.d + 2, this.oy + n2 * this.d + 3, this.ox + (n + 1) * this.d - 2, this.oy + (n2 + 1) * this.d - 3);
                graphics.drawLine(this.ox + (n + 1) * this.d - 2, this.oy + n2 * this.d + 2, this.ox + n * this.d + 2, this.oy + (n2 + 1) * this.d - 2);
                graphics.drawLine(this.ox + (n + 1) * this.d - 2, this.oy + n2 * this.d + 3, this.ox + n * this.d + 2, this.oy + (n2 + 1) * this.d - 3);
            } else if (this.table.cell[n][n2] == 2) {
                graphics.setColor(0, 0, 255);
                graphics.drawArc(this.ox + n * this.d + 1, this.oy + n2 * this.d + 1, this.d - 2, this.d - 2, 0, 360);
                graphics.drawArc(this.ox + n * this.d + 2, this.oy + n2 * this.d + 2, this.d - 4, this.d - 4, 0, 360);
            }
        }
    }

    protected void paint(Graphics graphics) {
        if (this.status == this.PREPARE) {
            int n;
            this.m = this.getWidth() / this.d;
            this.n = this.getHeight() / this.d;
            this.ox = (this.getWidth() - this.m * this.d) / 2;
            this.oy = (this.getHeight() - this.n * this.d) / 2;
            this.table.cell = new int[this.m][this.n];
            this.table.score = new int[this.m][this.n];
            this.table.score1 = new int[this.m][this.n];
            this.table.m = this.m;
            this.table.n = this.n;
            for (n = 0; n < this.m; ++n) {
                for (int i = 0; i < this.n; ++i) {
                    this.table.cell[n][i] = 0;
                }
            }
            graphics.setColor(this.backcolor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.bordercolor);
            for (n = 0; n <= this.m; ++n) {
                graphics.drawLine(this.ox + n * this.d, 0, this.ox + n * this.d, this.getHeight());
            }
            for (n = 0; n <= this.n; ++n) {
                graphics.drawLine(0, this.oy + n * this.d, this.getWidth(), this.oy + n * this.d);
            }
            this.x = this.xold = this.m / 2;
            this.y = this.yold = this.n / 2;
            if (!this.humanfirst) {
                this.table.cell[this.x][this.y] = this.comid;
            }
            this.drawCell(graphics, this.x, this.y, 1);
        } else if (this.status == this.KEYMOVE) {
            this.drawCell(graphics, this.xold, this.yold, 0);
            this.drawCell(graphics, this.x, this.y, 1);
            this.xold = this.x;
            this.yold = this.y;
        } else if (this.status == this.KEYENTER) {
            this.drawCell(graphics, this.xc, this.yc, 0);
            this.drawCell(graphics, this.x, this.y, 1);
            this.xold = this.x;
            this.yold = this.y;
        } else if (this.status == this.REFRESH) {
            int n;
            graphics.setColor(this.backcolor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.bordercolor);
            for (n = 0; n <= this.m; ++n) {
                graphics.drawLine(this.ox + n * this.d, 0, this.ox + n * this.d, this.getHeight());
            }
            for (n = 0; n <= this.n; ++n) {
                graphics.drawLine(0, this.oy + n * this.d, this.getWidth(), this.oy + n * this.d);
            }
            for (n = 0; n < this.m; ++n) {
                for (int i = 0; i < this.n; ++i) {
                    if (this.table.cell[n][i] == 0) continue;
                    this.drawCell(graphics, n, i, 0);
                }
            }
            this.drawCell(graphics, this.x, this.y, 1);
        } else if (this.status != this.DISPLAYHELP && this.status == this.DISPLAYRESULT) {
            this.drawCell(graphics, this.x, this.y, 0);
            this.drawCell(graphics, this.xc, this.yc, 0);
            if (this.userwin) {
                graphics.setColor(0, 255, 0);
                graphics.fillRect(this.bannerx, this.bannery, this.bannerwidth, this.bannerheight);
                graphics.setColor(this.bordercolor);
                graphics.drawRect(this.bannerx, this.bannery, this.bannerwidth, this.bannerheight);
                graphics.drawRect(this.bannerx + 1, this.bannery + 1, this.bannerwidth - 2, this.bannerheight - 2);
                graphics.setColor(0);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
                graphics.drawString("You win", this.bannerx + 12, this.bannery + 2, 0);
                graphics.drawString("Press 1...", this.bannerx + 10, this.bannery + 18, 0);
            } else {
                graphics.setColor(255, 0, 0);
                graphics.fillRect(this.bannerx, this.bannery, this.bannerwidth, this.bannerheight);
                graphics.setColor(this.bordercolor);
                graphics.drawRect(this.bannerx, this.bannery, this.bannerwidth, this.bannerheight);
                graphics.drawRect(this.bannerx + 1, this.bannery + 1, this.bannerwidth - 2, this.bannerheight - 2);
                graphics.setColor(this.backcolor);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
                graphics.drawString("You lose", this.bannerx + 10, this.bannery + 2, 0);
                graphics.drawString("Press 1...", this.bannerx + 10, this.bannery + 18, 0);
            }
        }
    }

    void update(int n) {
        this.status = n;
        this.repaint();
    }

    public void keyPressed(int n) {
        if (this.status == this.DISPLAYRESULT) {
            if (n == 49) {
                this.update(this.PREPARE);
            }
            return;
        }
        if (this.status == this.DISPLAYHELP) {
            if (n == 49) {
                this.update(this.REFRESH);
            }
            return;
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.x = this.x > 0 ? --this.x : this.m - 1;
                this.update(this.KEYMOVE);
                break;
            }
            case 5: {
                this.x = this.x < this.m - 1 ? ++this.x : 0;
                this.update(this.KEYMOVE);
                break;
            }
            case 1: {
                this.y = this.y > 0 ? --this.y : this.n - 1;
                this.update(this.KEYMOVE);
                break;
            }
            case 6: {
                this.y = this.y < this.n - 1 ? ++this.y : 0;
                this.update(this.KEYMOVE);
                break;
            }
            case 9: {
                if (this.table.cell[this.x][this.y] != 0) {
                    return;
                }
                this.table.cell[this.x][this.y] = this.userid;
                if (this.table.checkwin()) {
                    this.userwin = true;
                    this.update(this.DISPLAYRESULT);
                    return;
                }
                this.table.findSolution();
                this.table.cell[this.table.resX][this.table.resY] = this.comid;
                this.xc = this.table.resX;
                this.yc = this.table.resY;
                if (this.table.checkwin()) {
                    this.userwin = false;
                    this.update(this.DISPLAYRESULT);
                    return;
                }
                this.update(this.KEYENTER);
            }
        }
    }
}

