/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Hashtable;

public abstract class LocaleLanguageUtil {
    private static String localeLanguage;
    private static Hashtable messages;

    public static final void setLocaleLanguage() {
        localeLanguage = "en";
        String string = System.getProperty("microedition.locale");
        if (string != null) {
            int n = string.indexOf("-");
            if (n == 2) {
                string = string.substring(0, 2);
            }
            if (LocaleLanguageUtil.isLocaleLanguageValido(string)) {
                localeLanguage = string;
            }
        }
        if (messages == null) {
            messages = new Hashtable();
            messages.put("pt Sair", "Sair");
            messages.put("pt Recomecar", "Recome\u00e7ar");
            messages.put("pt Fim do Jogo", "Fim do Jogo");
            messages.put("pt Pause", "Pause");
            messages.put("en Sair", "Exit");
            messages.put("en Recomecar", "Restart");
            messages.put("en Fim do Jogo", "Game Over");
            messages.put("en Pause", "Pause");
        }
    }

    private static final boolean isLocaleLanguageValido(String string) {
        return string != null && (string.equals("pt") || string.equals("en"));
    }

    public static final String getLocaleLanguage() {
        return localeLanguage;
    }

    public static final void setLocaleLanguage(String string) {
        localeLanguage = string;
    }

    public static final String getLocalizedMessage(String string) {
        return (String)messages.get(LocaleLanguageUtil.getLocaleLanguage() + " " + string) + "";
    }

    public static final int getLocaleLanguageAsInt() {
        if (LocaleLanguageUtil.getLocaleLanguage().equals("en")) {
            return 2;
        }
        return 1;
    }

    public static final String getLocaleLanguage(int n) {
        if (n == 2) {
            return "en";
        }
        return "pt";
    }

    static {
        messages = null;
    }
}

