/*
 * Decompiled with CFR 0.152.
 */
package telas.jogo;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import telas.Desenho;
import telas.IDesenho;
import telas.jogo.DesenhoBola;
import telas.jogo.DesenhoJogador;
import telas.jogo.DesenhoQuadra;
import telas.jogo.TelaJogo;
import util.LocaleLanguageUtil;
import util.ProporcoesUtil;

public final class DesenhoTela
extends Desenho {
    public boolean _5 = false;
    final DesenhoQuadra quadra;
    final DesenhoJogador jogador;
    final Vector bolas;
    private DesenhoBola bolaAux;
    private boolean fimDeJogo = false;

    public DesenhoTela(IDesenho iDesenho) {
        super(iDesenho);
        this.posiciona();
        this.quadra = new DesenhoQuadra(this);
        this.jogador = new DesenhoJogador(this);
        this.bolas = this.newBolas();
    }

    private final Vector newBolas() {
        Vector<DesenhoBola> vector = new Vector<DesenhoBola>();
        vector.addElement(new DesenhoBola(this));
        return vector;
    }

    private final void posiciona() {
        this.l = ProporcoesUtil.L;
        this.a = ProporcoesUtil.A;
        this.x = (this.parent.getL() - this.l) / 2;
        this.y = (this.parent.getA() - this.a + ProporcoesUtil.PLACAR_A + 1) / 2;
    }

    public void draw(Graphics graphics) {
        this.limpaFundo(graphics);
        this.quadra.draw(graphics);
        for (int i = 0; i < this.bolas.size(); ++i) {
            this.bolaAux = (DesenhoBola)this.bolas.elementAt(i);
            if (this.bolaAux.contador.x++ == this.bolaAux.direcao.x) {
                this.bolaAux.addY(this.bolaAux.passo.y);
                this.bolaAux.contador.x = 0;
            }
            if (this.bolaAux.contador.y++ == this.bolaAux.direcao.y) {
                this.bolaAux.addX(this.bolaAux.passo.x);
                this.bolaAux.contador.y = 0;
            }
            if (this.bolaAux.passo.x > 0) {
                if (this.bolaAux.collidesWithDeEsquerdaParaDireita(this.quadra)) {
                    this.bolaAux.passo.x = -1;
                } else if (this.bolaAux.x + this.bolaAux.l == this.l + 1) {
                    this.removeBola(this.bolaAux);
                    this.bolaAux = null;
                    continue;
                }
            } else if (this.bolaAux.collidesWithDeDeDireitaParaEsquerda(this.jogador)) {
                this.bolaAux.passo.x = 1;
                ((TelaJogo)this.parent).ponto(1, this.bolaAux);
            } else {
                if (this.bolaAux.x == 0) {
                    this.removeBola(this.bolaAux);
                    this.bolaAux = null;
                    continue;
                }
                if (this.bolaAux.passo.y > 0) {
                    if (this.bolaAux.collidesWithDeCimaParaBaixo(this.jogador)) {
                        this.bolaAux.passo.y = -1;
                    }
                } else if (this.bolaAux.collidesWithDeBaixoParaCima(this.jogador)) {
                    this.bolaAux.passo.y = 1;
                }
            }
            if (this.bolaAux.passo.y > 0) {
                if (this.bolaAux.collidesWithDeCimaParaBaixo(this.quadra)) {
                    this.bolaAux.passo.y = -1;
                } else if (this.bolaAux.y + this.bolaAux.a == this.a + 1) {
                    this.removeBola(this.bolaAux);
                    this.bolaAux = null;
                    continue;
                }
            } else if (this.bolaAux.collidesWithDeBaixoParaCima(this.quadra)) {
                this.bolaAux.passo.y = 1;
            } else if (this.bolaAux.y == 0) {
                this.removeBola(this.bolaAux);
                this.bolaAux = null;
                continue;
            }
            this.bolaAux.draw(graphics);
        }
        if (this.jogador.up && this.jogador.y > 0) {
            this.jogador.addY(-1);
        } else if (this.jogador.down && this.jogador.y + this.jogador.a < this.a) {
            this.jogador.addY(1);
        } else if (this.jogador.left && this.jogador.x > 0) {
            this.jogador.addX(-1);
        } else if (this.jogador.right && this.jogador.x + this.jogador.l + ProporcoesUtil.LIMITADOR_JOGADOR < this.l) {
            this.jogador.addX(1);
        }
        this.jogador.draw(graphics);
        if (this.bolas.size() == 0) {
            this.fimDoJogo(graphics);
        }
    }

    private final void fimDoJogo(Graphics graphics) {
        this.setFimDeJogo(true);
        graphics.setColor(0);
        graphics.drawString(LocaleLanguageUtil.getLocalizedMessage("Fim do Jogo"), this.getX() + this.l / 2, this.getY() + this.a / 2, 17);
    }

    private final void limpaFundo(Graphics graphics) {
        graphics.setColor(39448);
        graphics.fillRect(this.getX(), this.getY(), this.l, this.a);
        graphics.setColor(16745102);
        graphics.drawRect(this.getX() - 1, this.getY() - 1, this.l + 1, this.a + 1);
    }

    public final void addBola(DesenhoBola desenhoBola) {
        DesenhoBola desenhoBola2 = new DesenhoBola(this);
        desenhoBola2.passo.x = desenhoBola.passo.x;
        desenhoBola2.passo.y = -desenhoBola.passo.y;
        desenhoBola2.x = desenhoBola.x;
        desenhoBola2.y = desenhoBola.y;
        this.bolas.addElement(desenhoBola2);
    }

    public final void removeBola(IDesenho iDesenho) {
        this.bolas.removeElement(iDesenho);
        System.gc();
    }

    public final void drawPause(Graphics graphics) {
        graphics.setColor(0);
        graphics.drawString(LocaleLanguageUtil.getLocalizedMessage("Pause"), this.getX() + this.l / 2, this.getY() + this.a / 2, 17);
    }

    public final void setFimDeJogo(boolean bl) {
        this.fimDeJogo = bl;
    }

    public final boolean isFimDeJogo() {
        return this.fimDeJogo;
    }
}

