/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGSVGElement;

public class PocketInclinometer
extends MIDlet {
    static PocketInclinometer instance;
    static Display display;
    static Command cmIndietro;
    static String sensorModel;
    static boolean primoAvvio;
    static int ny_calibrato;
    static int nx_calibrato;
    Canvas splash = new SplashScreen();
    public static Alert alert1;

    public void startApp() {
        instance = this;
        display = Display.getDisplay((MIDlet)this);
        this.splash.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.splash);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public static void showAlert(String string) {
        alert1.setString(string);
        alert1.setTimeout(5000);
        display.setCurrent((Displayable)alert1);
    }

    public void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    static {
        cmIndietro = new Command("Indietro", 1, 1);
        primoAvvio = false;
        alert1 = new Alert("Help");
    }

    class C
    extends Canvas
    implements Runnable,
    DataListener {
        private Image dukeImg = null;
        private Image barra = null;
        private Image barra2 = null;
        private Image menu = null;
        private SVGImage svgImage = null;
        private ScalableGraphics gc;
        SVGSVGElement root;
        SVGElement rot;
        String namespace;
        Document document;
        Thread thread;
        boolean open = false;
        boolean cmdHelp = false;
        boolean cmdExit = false;
        boolean cmdGradi = false;
        boolean cmdInfo = false;
        boolean calibrazioneMenu = false;
        boolean readyToCalibrate = false;
        int aggiornamentoTF;
        int ywrite = 0;
        int counter = 0;
        float[] ref_x;
        float[] ref_y;
        float dist2;
        float last_cs;
        float last_sn;
        int nx_app;
        int ny_app;
        int nz_app;
        int nz_calibrato;
        int posizione = 90;
        SensorConnection conn;
        static final int QUEUE_SIZE = 4;
        int[] queue_x = new int[4];
        int[] queue_y = new int[4];
        int[] queue_z = new int[4];
        int queue_idx = -1;
        Object sens_lock = new Object();
        int sens_x;
        int sens_y;
        int sens_z;
        int sens_data_ready = 0;
        static final boolean SMOOTH_DATA = true;

        public double toGradi(double d) {
            double d2 = d;
            double d3 = d2 * d2;
            return d2 * (1.0 + d3 * (0.16666666666666 + d3 * (0.075 + d3 * (0.044642857142857144 + d3 * (0.030381944444444444 + d3 * 0.022372159090909092)))));
        }

        double aTan2(double d, double d2) {
            double d3;
            double d4 = 0.7853981633974483;
            double d5 = 3.0 * d4;
            double d6 = Math.abs(d);
            if (d2 >= 0.0) {
                double d7 = (d2 - d6) / (d2 + d6);
                d3 = d4 - d4 * d7;
            } else {
                double d8 = (d2 + d6) / (d6 - d2);
                d3 = d5 - d4 * d8;
            }
            return d < 0.0 ? -d3 : d3;
        }

        public int write(Graphics graphics, int n, int n2, String string) {
            if (n2 == 0) {
                graphics.setFont(Font.getFont((int)32, (int)0, (int)8));
            }
            if (n2 == 1) {
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            }
            graphics.setColor(0);
            graphics.drawString(string, 0, n, 20);
            return n + graphics.getFont().getHeight();
        }

        public final void startSound(String string) {
            final String string2 = string;
            Thread thread = new Thread(){

                public void run() {
                    try {
                        InputStream inputStream = this.getClass().getResourceAsStream("/" + string2);
                        Player player = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
                        player.realize();
                        player.start();
                        Thread.currentThread().start();
                        Thread.sleep(5000L);
                        player.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            System.gc();
        }

        C() {
            this.createSVG();
            this.preloadImmagini();
            this.thread = new Thread(this);
            this.thread.start();
        }

        void preloadImmagini() {
            try {
                this.dukeImg = Image.createImage((String)"/res/sfon.gif");
                this.barra = Image.createImage((String)"/res/barra.jpg");
                this.barra2 = Image.createImage((String)"/res/barra2.jpg");
                this.menu = Image.createImage((String)"/res/menu.gif");
                RmsManager.rmsReadPrimoAvvio();
                RmsManager.rmsReadCalibrazione();
                RmsManager.rmsReadSfallo();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void createSVG() {
            this.gc = ScalableGraphics.createInstance();
            try {
                this.svgImage = (SVGImage)SVGImage.createImage((InputStream)this.getClass().getResourceAsStream("/res/rotate.svg"), null);
            }
            catch (Exception exception) {
                System.out.println("Error loading SVG image!");
                exception.printStackTrace();
            }
            this.svgImage.setViewportWidth(this.getWidth());
            this.svgImage.setViewportHeight(this.getHeight());
            this.document = this.svgImage.getDocument();
            this.rot = (SVGElement)this.document.getElementById("rot");
            this.root = (SVGSVGElement)this.document.getDocumentElement();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.open) {
                if (this.cmdInfo) {
                    this.drawInfo(graphics);
                    this.cmdHelp = false;
                } else if (this.cmdHelp) {
                    this.drawHelp(graphics);
                    this.cmdInfo = false;
                } else if (this.aggiornamentoTF == 1) {
                    this.drawUpdate(graphics, 1);
                } else {
                    this.drawPrincipale(graphics);
                    if (this.cmdGradi) {
                        graphics.drawString("X:" + this.nx_app + " Y:" + this.ny_app + " Z:" + this.nz_app, 0, 22, 0);
                        graphics.setColor(0);
                    }
                }
                this.drawMenu(graphics);
                if (this.posizione == 90) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/back.gif");
                }
                if (this.posizione == 75) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/raw.gif");
                }
                if (this.posizione == 60) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/calibrate.gif");
                }
                if (this.posizione == 45) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/info.gif");
                }
                if (this.posizione == 30) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/help.gif");
                }
                if (this.posizione == 15) {
                    this.drawPosizioneMenu(graphics, this.posizione, "res/exit.gif");
                }
            } else if (this.cmdExit) {
                PocketInclinometer.this.exit();
            } else if (this.cmdInfo) {
                this.drawInfo(graphics);
            } else if (this.cmdHelp) {
                this.drawHelp(graphics);
            } else if (this.aggiornamentoTF == 1) {
                this.drawUpdate(graphics, 1);
            } else if (this.aggiornamentoTF == 2) {
                this.drawUpdate(graphics, 2);
            } else if (!primoAvvio) {
                this.drawPrimoAvvio(graphics);
            } else if (this.calibrazioneMenu) {
                this.drawCalibrazione(graphics);
            } else {
                this.drawPrincipale(graphics);
                if (this.cmdGradi) {
                    graphics.drawString("X:" + this.nx_app + " Y:" + this.ny_app + " Z:" + this.nz_app, 0, 22, 0);
                    graphics.setColor(0);
                }
            }
        }

        public void drawPrincipale(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.gc.bindTarget((Object)graphics);
            this.gc.render(0, 20, (ScalableImage)this.svgImage);
            this.gc.releaseTarget();
            graphics.setColor(0);
            this.drawBarra(graphics, 0, "res/barra.jpg");
            this.drawBarra(graphics, 1, "res/barra2.jpg");
            graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            double d = this.nx_app;
            double d2 = this.ny_app;
            double d3 = this.nz_app;
            double d4 = this.aTan2(d2, d);
            d4 = (int)Math.toDegrees(d4);
            d3 = (int)(d3 / 2.9 / 4.0);
            graphics.drawString("Y\u00b0:" + d4 + " Z\u00b0:" + d3, this.getWidth(), this.getHeight() - 20, 40);
        }

        void drawCalibrazione(Graphics graphics) {
            double d = this.aTan2(this.ny_app, this.nx_app);
            if ((d = (double)((int)Math.toDegrees(d))) > -45.0 && d < 45.0 && (double)this.nz_app / 2.9 / 4.0 < 45.0) {
                this.drawPrincipalePerCalibrazione(graphics);
                this.readyToCalibrate = true;
            } else {
                this.readyToCalibrate = false;
                try {
                    Image image = Image.createImage((String)"/res/rotazione.gif");
                    graphics.drawImage(image, this.getWidth() / 2, this.getHeight() / 2, 3);
                    this.drawBarra(graphics, 0, "barra.jpg");
                    this.drawBarra(graphics, 2, "barra2.jpg");
                    graphics.setColor(0xFFFFFF);
                    graphics.drawString("Cancel", 0, this.getHeight(), 36);
                    graphics.setColor(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void drawPrincipalePerCalibrazione(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.gc.bindTarget((Object)graphics);
            this.gc.render(0, 20, (ScalableImage)this.svgImage);
            this.gc.releaseTarget();
            graphics.setColor(0);
            this.drawBarra(graphics, 0, "barra.jpg");
            this.drawBarra(graphics, 2, "barra2.jpg");
            graphics.setColor(0xFFFFFF);
            graphics.drawString("Cancel", 0, this.getHeight(), 36);
            graphics.setColor(0);
            try {
                Image image = Image.createImage((String)"/res/testo.gif");
                graphics.drawImage(image, 30, this.getHeight() / 2 - 8, 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            double d = this.nx_app;
            double d2 = this.ny_app;
            double d3 = this.nz_app;
            double d4 = this.aTan2(d2, d);
            d4 = (int)Math.toDegrees(d4);
            d3 = (int)(d3 / 2.9 / 4.0);
            graphics.drawString("Y\u00b0:" + d4 + " Z\u00b0:" + d3, this.getWidth(), this.getHeight() - 20, 40);
        }

        void drawInfo(Graphics graphics) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0);
            graphics.drawImage(this.dukeImg, 0, 22, 0);
            double d = this.aTan2(ny_calibrato, nx_calibrato);
            d = (int)Math.toDegrees(d);
            this.ywrite = 42;
            this.ywrite = this.write(graphics, this.ywrite, 1, "Pocket Inclinometer (ver. 1.1)");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Copyright 2008-09");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Davide Perini,");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Renato Perini.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "");
            this.ywrite = this.write(graphics, this.ywrite, 0, "More info and software:");
            this.ywrite = this.write(graphics, this.ywrite, 0, "http://www.dpsoftware.org");
            this.ywrite = this.write(graphics, this.ywrite, 0, "");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Sensor model: " + sensorModel);
            this.ywrite = this.write(graphics, this.ywrite, 0, "");
            if (Math.abs(d) != 0.0) {
                this.ywrite = this.write(graphics, this.ywrite, 0, "Motion sensor accuracy: -" + Math.abs(d) + "\u00b0");
                this.ywrite = this.write(graphics, this.ywrite, 0, "After calibration: -1.0\u00b0");
            } else {
                this.ywrite = this.write(graphics, this.ywrite, 0, "Motion sensor accuracy:");
                this.ywrite = this.write(graphics, this.ywrite, 0, "not yet calculated");
            }
            this.drawBarra(graphics, 0, "barra.jpg");
            this.drawBarra(graphics, 1, "barra2.jpg");
        }

        void drawHelp(Graphics graphics) {
            this.ywrite = 42;
            graphics.setColor(0);
            graphics.drawImage(this.dukeImg, 0, 22, 0);
            graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            this.ywrite = 42;
            this.ywrite = this.write(graphics, this.ywrite, 1, "Help");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Remember to calibrate your");
            this.ywrite = this.write(graphics, this.ywrite, 0, "motion sensor before using this");
            this.ywrite = this.write(graphics, this.ywrite, 0, "software. Press the update");
            this.ywrite = this.write(graphics, this.ywrite, 0, "button to check if a new version");
            this.ywrite = this.write(graphics, this.ywrite, 0, "is available.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "");
            this.ywrite = this.write(graphics, this.ywrite, 1, "Shortcuts");
            this.ywrite = this.write(graphics, this.ywrite, 0, "* to exit.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "# calibrate sensor.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "7 switch to raw sensor data.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "9 show info.");
            this.ywrite = this.write(graphics, this.ywrite, 0, "");
            this.drawBarra(graphics, 0, "barra.jpg");
            this.drawBarra(graphics, 1, "barra2.jpg");
            graphics.setColor(0xFFFFFF);
            graphics.drawString("Update", this.getWidth(), this.getHeight(), 40);
            graphics.setColor(0);
        }

        void drawUpdate(Graphics graphics, int n) {
            this.ywrite = 42;
            graphics.setColor(0);
            graphics.drawImage(this.dukeImg, 0, 22, 0);
            graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            this.drawBarra(graphics, 0, "barra.jpg");
            if (n == 1) {
                this.drawBarra(graphics, 1, "barra2.jpg");
                graphics.setColor(0);
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                graphics.drawString("No update found.", this.getWidth() / 2, this.getHeight() / 2, 33);
                graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
                graphics.drawString("You have the latest version.", this.getWidth() / 2, this.getHeight() / 2 + graphics.getFont().getHeight(), 33);
            }
            if (n == 2) {
                this.drawBarra(graphics, 2, "barra2.jpg");
                graphics.setColor(0xFFFFFF);
                graphics.drawString("Yes", 0, this.getHeight(), 36);
                graphics.drawString("No", this.getWidth(), this.getHeight(), 40);
                graphics.setColor(0);
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                graphics.drawString("Update found!", this.getWidth() / 2, this.getHeight() / 2, 33);
                graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
                graphics.drawString("Download it now?", this.getWidth() / 2, this.getHeight() / 2 + graphics.getFont().getHeight(), 33);
            }
        }

        void drawPrimoAvvio(Graphics graphics) {
            graphics.drawImage(this.dukeImg, 0, 22, 0);
            this.drawBarra(graphics, 0, "barra.jpg");
            this.drawBarra(graphics, 2, "barra2.jpg");
            graphics.setColor(0xFFFFFF);
            graphics.drawString("Ok", this.getWidth() / 2, this.getHeight(), 33);
            graphics.setColor(0);
            this.ywrite = 82;
            graphics.drawString("First execution.", this.getWidth() / 2, 82, 33);
            this.ywrite = this.write(graphics, this.ywrite, 0, "This is the first execution of");
            this.ywrite = this.write(graphics, this.ywrite, 0, "Pocket Inclinometer. To fine tune");
            this.ywrite = this.write(graphics, this.ywrite, 0, "the sensor, remember to calibrate");
            this.ywrite = this.write(graphics, this.ywrite, 0, "it from the \"calibrate\" menu. ");
            this.ywrite = this.write(graphics, this.ywrite, 0, "For a precise calibration, you ");
            this.ywrite = this.write(graphics, this.ywrite, 0, "need a perfectly horizontal and");
            this.ywrite = this.write(graphics, this.ywrite, 0, "and flat surface. (remember this");
            this.ywrite = this.write(graphics, this.ywrite, 0, "surface will be considered \"0\"");
            this.ywrite = this.write(graphics, this.ywrite, 0, "degrees).");
        }

        public void drawBarra(Graphics graphics, int n, String string) {
            if (n == 0) {
                for (int i = 0; i < this.getWidth(); i += 10) {
                    graphics.drawImage(this.barra, i, 0, 0);
                }
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                graphics.setColor(0xFFFFFF);
                graphics.drawString("Pocket Inclinometer", this.getWidth() / 2, 2, 17);
                graphics.setColor(0);
            } else if (n == 1) {
                for (int i = 0; i <= this.getWidth(); i += 10) {
                    graphics.drawImage(this.barra2, i, this.getHeight(), 40);
                }
                graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
                graphics.setColor(0xFFFFFF);
                graphics.drawString("Menu", 0, this.getHeight(), 36);
                if (this.open) {
                    graphics.drawString("Ok", this.getWidth() / 2, this.getHeight(), 33);
                }
                graphics.setColor(0);
            } else {
                for (int i = 0; i <= this.getWidth(); i += 10) {
                    graphics.drawImage(this.barra2, i, this.getHeight(), 40);
                }
                graphics.setColor(0);
            }
        }

        public void drawMenu(Graphics graphics) {
            graphics.drawImage(this.menu, 0, this.getHeight() - 20, 36);
        }

        public void drawPosizioneMenu(Graphics graphics, int n, String string) {
            try {
                Image image = Image.createImage((String)("/" + string));
                graphics.drawImage(image, 0, this.getHeight() - (n + 5), 36);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void calibrazione() {
            this.cmdHelp = false;
            this.cmdInfo = false;
            this.cmdGradi = false;
            this.ny_app += ny_calibrato;
            this.nz_calibrato = 0;
            ny_calibrato = 0;
            nx_calibrato = 0;
            nx_calibrato = this.nx_app;
            ny_calibrato = this.ny_app;
            this.nz_calibrato = this.nz_app;
            this.startSound("res/calibrated.wav");
            this.open = false;
            RmsManager.rmsStoreCalibrazione(ny_calibrato);
            RmsManager.rmsStoreSfallo(nx_calibrato);
        }

        public void keyPressed(int n) {
            if (n == -6 && this.aggiornamentoTF != 2 && !this.calibrazioneMenu) {
                this.posizione = 90;
                this.open = !this.open;
            }
            if (n == -6 && this.aggiornamentoTF == 2) {
                Update.downloadJar();
                this.aggiornamentoTF = 0;
            }
            if (n == -7 && this.aggiornamentoTF == 2) {
                this.aggiornamentoTF = 0;
            }
            if (n == -6 && this.calibrazioneMenu || n == -6 && this.readyToCalibrate) {
                this.readyToCalibrate = false;
                this.calibrazioneMenu = false;
            }
            if (this.getGameAction(n) == 8 && !primoAvvio) {
                RmsManager.rmsStorePrimoAvvio(true);
            }
            if (this.getGameAction(n) == 8 && this.open) {
                if (this.posizione == 90) {
                    this.calibrazioneMenu = false;
                    this.cmdHelp = false;
                    this.cmdInfo = false;
                    this.aggiornamentoTF = 0;
                }
                if (this.posizione == 75) {
                    this.cmdHelp = false;
                    this.cmdInfo = false;
                    this.cmdGradi = !this.cmdGradi;
                }
                if (this.posizione == 60) {
                    this.cmdInfo = false;
                    this.cmdHelp = false;
                    this.calibrazioneMenu = true;
                }
                if (this.posizione == 45) {
                    this.cmdHelp = false;
                    this.cmdInfo = true;
                }
                if (this.posizione == 30) {
                    this.cmdInfo = false;
                    this.cmdHelp = true;
                }
                if (this.posizione == 15) {
                    this.cmdExit = true;
                }
                this.open = false;
            }
            if (n == -7 && this.cmdHelp) {
                this.aggiornamentoTF = Update.goUpdate();
                this.cmdHelp = false;
            }
            if (this.getGameAction(n) == 6 || this.getGameAction(n) == 2) {
                this.posizione = this.posizione == 15 ? 90 : (this.posizione -= 15);
            }
            if (this.getGameAction(n) == 1 || this.getGameAction(n) == 5) {
                this.posizione = this.posizione == 90 ? 15 : (this.posizione += 15);
            }
            if (this.getGameAction(n) == 9) {
                this.cmdInfo = false;
                this.cmdHelp = false;
                this.cmdGradi = !this.cmdGradi;
            }
            if (this.getGameAction(n) == 10) {
                this.cmdInfo = true;
            }
            if (this.getGameAction(n) == 11) {
                if (this.cmdInfo || this.cmdHelp) {
                    this.cmdGradi = false;
                    this.cmdHelp = false;
                    this.cmdInfo = false;
                } else {
                    PocketInclinometer.this.exit();
                }
            }
            if (this.getGameAction(n) == 12 && !this.calibrazioneMenu) {
                this.cmdInfo = false;
                this.cmdHelp = false;
                this.calibrazioneMenu = true;
            }
            if (this.getGameAction(n) == 12 && this.readyToCalibrate) {
                this.calibrazione();
                this.calibrazioneMenu = false;
                this.readyToCalibrate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processData() {
            float f;
            float f2;
            int n = 140;
            int n2 = 140;
            Object object = this.sens_lock;
            synchronized (object) {
                f2 = this.sens_x;
                f = this.sens_y;
            }
            float f3 = this.sens_x * this.sens_x + this.sens_y * this.sens_y;
            if (f3 > 0.0f) {
                f3 = (float)Math.sqrt(f3);
                float f4 = f /= f3;
                float f5 = -(f2 /= f3);
                f2 = f4;
                f = f5;
                SVGMatrix sVGMatrix = this.root.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                SVGMatrix sVGMatrix2 = this.root.createSVGMatrixComponents(f2, -f, f, f2, 0.0f, 0.0f);
                sVGMatrix = sVGMatrix.mTranslate((float)n, (float)n2).mMultiply(sVGMatrix2).mTranslate((float)(-n), (float)(-n2));
                this.rot.setMatrixTrait("transform", sVGMatrix);
            }
        }

        public void run() {
            this.init_sensor();
            this.init_ref();
            while (this.thread != null) {
                ++this.counter;
                if (!this.open) {
                    this.processData();
                }
                this.repaint();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.counter % 50 != 0) continue;
                DeviceControl.setLights((int)0, (int)100);
            }
            this.done_sensor();
        }

        void init_ref() {
            int n = 30;
            int n2 = 360 / n;
            float f = 0.0f;
            this.ref_x = new float[n2];
            this.ref_y = new float[n2];
            for (int i = 0; i < n2; ++i) {
                this.ref_x[i] = (float)Math.cos((double)f * Math.PI / 180.0);
                this.ref_y[i] = (float)Math.sin((double)f * Math.PI / 180.0);
                f += (float)n;
            }
            float f2 = this.ref_x[1] - this.ref_x[0];
            float f3 = this.ref_y[1] - this.ref_y[0];
            this.dist2 = f2 * f2 + f3 * f3;
            this.dist2 /= 4.0f;
        }

        int find_ref(float f, float f2, int n) {
            float f3 = 100.0f;
            int n2 = 0;
            for (int i = 0; i < this.ref_x.length; ++i) {
                float f4 = f - this.ref_x[i];
                float f5 = f2 - this.ref_y[i];
                float f6 = f4 * f4 + f5 * f5;
                if (!(f6 < f3)) continue;
                f3 = f6;
                n2 = i;
            }
            return n2;
        }

        void init_sensor() {
            SensorInfo[] sensorInfoArray = SensorManager.findSensors(null, null);
            int n = sensorInfoArray.length;
            for (int i = 0; i < n; ++i) {
                String string = sensorInfoArray[i].getUrl();
                if (string.indexOf("acceleration") <= -1) continue;
                try {
                    this.conn = (SensorConnection)Connector.open((String)string);
                    SensorInfo sensorInfo = this.conn.getSensorInfo();
                    ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
                    this.conn.setDataListener((DataListener)this, 1);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("No sensors found!!!");
        }

        void done_sensor() {
            if (this.conn == null) {
                return;
            }
            try {
                this.conn.removeDataListener();
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.conn = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dataReceived(SensorConnection sensorConnection, Data[] dataArray, boolean bl) {
            Object object = this.sens_lock;
            synchronized (object) {
                sensorModel = sensorConnection.getSensorInfo().getModel();
                ChannelInfo[] channelInfoArray = sensorConnection.getSensorInfo().getChannelInfos();
                switch (channelInfoArray[0].getDataType()) {
                    case 2: {
                        this.smoothIntData(dataArray);
                        break;
                    }
                    case 1: {
                        this.smoothDoubleData(dataArray);
                        break;
                    }
                    case 4: {
                        PocketInclinometer.showAlert("Sensor data type not supported.");
                    }
                }
            }
        }

        void smoothDoubleData(Data[] dataArray) {
            int n;
            double[] dArray = dataArray[0].getDoubleValues();
            double[] dArray2 = dataArray[1].getDoubleValues();
            double[] dArray3 = dataArray[2].getDoubleValues();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            d2 = dArray[dArray.length - 1];
            d = dArray2[dArray2.length - 1] - (double)ny_calibrato;
            d3 = dArray3[dArray3.length - 1];
            this.nx_app = (int)d2;
            this.ny_app = (int)d;
            this.nz_app = (int)d3;
            if (this.queue_idx == -1) {
                for (n = 0; n < 4; ++n) {
                    this.queue_x[n] = (int)d2;
                    this.queue_y[n] = (int)d;
                    this.queue_z[n] = (int)d3;
                }
            } else {
                this.queue_x[this.queue_idx] = (int)d2;
                this.queue_y[this.queue_idx] = (int)d;
                this.queue_z[this.queue_idx] = (int)d3;
            }
            this.queue_idx = (this.queue_idx + 1) % 4;
            this.sens_z = 0;
            this.sens_y = 0;
            this.sens_x = 0;
            for (n = 0; n < 4; ++n) {
                this.sens_x += this.queue_x[n];
                this.sens_y += this.queue_y[n];
                this.sens_z += this.queue_z[n];
            }
            this.sens_x /= 4;
            this.sens_y /= 4;
            this.sens_z /= 4;
            this.sens_data_ready = 1;
        }

        void smoothIntData(Data[] dataArray) {
            int n;
            int[] nArray = dataArray[0].getIntValues();
            int[] nArray2 = dataArray[1].getIntValues();
            int[] nArray3 = dataArray[2].getIntValues();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n3 = nArray[nArray.length - 1];
            n2 = nArray2[nArray2.length - 1] - ny_calibrato;
            n4 = nArray3[nArray3.length - 1];
            this.nx_app = n3;
            this.ny_app = n2;
            this.nz_app = n4;
            if (this.queue_idx == -1) {
                for (n = 0; n < 4; ++n) {
                    this.queue_x[n] = n3;
                    this.queue_y[n] = n2;
                    this.queue_z[n] = n4;
                }
            } else {
                this.queue_x[this.queue_idx] = n3;
                this.queue_y[this.queue_idx] = n2;
                this.queue_z[this.queue_idx] = n4;
            }
            this.queue_idx = (this.queue_idx + 1) % 4;
            this.sens_z = 0;
            this.sens_y = 0;
            this.sens_x = 0;
            for (n = 0; n < 4; ++n) {
                this.sens_x += this.queue_x[n];
                this.sens_y += this.queue_y[n];
                this.sens_z += this.queue_z[n];
            }
            this.sens_x /= 4;
            this.sens_y /= 4;
            this.sens_z /= 4;
            this.sens_data_ready = 1;
        }
    }

    class SplashScreen
    extends Canvas {
        private Image barraCaricamento = null;
        private Image splashImg = null;
        Timer timer = new Timer();
        C cv = new C();
        int tempCaricamento = 0;

        SplashScreen() {
            this.preloadSplash();
        }

        void preloadSplash() {
            try {
                this.barraCaricamento = Image.createImage((String)"/res/barraCaricamento.gif");
                this.splashImg = Image.createImage((String)"/res/splash.gif");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void keyPressed(int n) {
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 1L);
        }

        private void dismiss() {
            this.timer.cancel();
            this.splashImg = null;
            this.barraCaricamento = null;
            PocketInclinometer.this.splash = null;
            System.gc();
            this.cv.setFullScreenMode(true);
            display.setCurrent((Displayable)this.cv);
        }

        public void paint(Graphics graphics) {
            this.tempCaricamento += 3;
            try {
                graphics.drawImage(this.splashImg, this.getWidth() / 2, this.getHeight() / 2, 3);
                for (int i = 0; i < this.tempCaricamento - 9; ++i) {
                    graphics.drawImage(this.barraCaricamento, i + (this.getWidth() / 2 - 49), this.getHeight() / 2 + 118, 36);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                for (int i = 0; i <= 50; ++i) {
                    SplashScreen.this.repaint();
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SplashScreen.this.dismiss();
            }
        }
    }
}

