/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class MyCanvas
extends Canvas {
    private static final int NOTHING = 0;
    private static final int CORRECT = 1;
    private static final int DISPLACED = 2;
    private int width = this.getWidth();
    private int height = this.getHeight() - 1;
    private int numberOfRows;
    private int numberOfColumns;
    private int numberOfBalls;
    private int pinholeSize;
    private int resultSize;
    private int pinholeBorder;
    private int resultBorder;
    private Vector pinholeRows;
    private Vector resultRows;
    private int currentRow;
    private int currentColumn;
    private Vector colors;
    private int[][] guesses;
    private int[][] results;
    private Vector facit;
    private boolean showFacit;
    private String trailingMessage;
    private String messageToDraw;
    public boolean messageIsShowing;
    private boolean gameOver;

    public void restartGame(int n, int n2, int n3) {
        this.initGame(n, n2, n3);
    }

    public MyCanvas() {
        this.initGame(8, 4, 6);
    }

    private void initGame(int n, int n2, int n3) {
        int n4;
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.numberOfBalls = n3;
        this.currentRow = this.numberOfRows - 1;
        this.currentColumn = 0;
        this.showFacit = false;
        this.facit = new Vector();
        Random random = new Random();
        int n5 = 0;
        while (n5 < this.numberOfColumns) {
            n4 = (random.nextInt() >>> 1) % this.numberOfBalls;
            Integer n6 = new Integer(1 + n4);
            if (this.facit.contains(n6)) continue;
            this.facit.addElement(n6);
            ++n5;
        }
        this.guesses = new int[this.numberOfRows][this.numberOfColumns];
        this.results = new int[this.numberOfRows][this.numberOfColumns];
        for (n4 = 0; n4 < this.numberOfRows; ++n4) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                this.guesses[n4][i] = 0;
                this.results[n4][i] = 0;
            }
        }
        this.pinholeRows = new Vector();
        this.resultRows = new Vector();
        n4 = this.height / this.numberOfRows;
        int n7 = this.width / (this.numberOfColumns + 2);
        int n8 = n7 * this.numberOfColumns;
        int n9 = (this.width - n8) / (this.numberOfColumns / 2);
        this.pinholeBorder = n4 / 6;
        this.resultBorder = 3;
        this.pinholeSize = n4 - 2 * this.pinholeBorder;
        int n10 = n4 / 5;
        this.resultSize = n4 / 2 - 2 * this.resultBorder + 3;
        for (int i = n4; i < this.height + 1; i += n4) {
            int n11;
            PinholeRow pinholeRow = new PinholeRow();
            ResultRow resultRow = new ResultRow();
            for (n11 = 0; n11 < this.numberOfColumns; ++n11) {
                pinholeRow.addColumn(n11 * n7 + n10, i - n4 + n10);
            }
            for (n11 = 0; n11 < this.numberOfColumns / 2; ++n11) {
                resultRow.addPosition(n8 + n9 / 3 + n11 * n9 + 3, i - n4 + 3);
                resultRow.addPosition(n8 + n9 / 3 + n11 * n9 + 3, i - n4 + n4 / 2 + 3);
            }
            this.pinholeRows.addElement(pinholeRow);
            this.resultRows.addElement(resultRow);
        }
        this.colors = new Vector();
        this.colors.addElement(null);
        this.colors.addElement(new Color(255, 0, 0));
        this.colors.addElement(new Color(0, 255, 0));
        this.colors.addElement(new Color(0, 0, 255));
        this.colors.addElement(new Color(0, 255, 255));
        this.colors.addElement(new Color(255, 0, 255));
        this.colors.addElement(new Color(255, 255, 0));
        this.colors.addElement(new Color(255, 186, 193));
        this.colors.addElement(new Color(161, 124, 51));
        this.colors.addElement(new Color(171, 171, 171));
        this.colors.addElement(new Color(136, 93, 10));
        this.colors.addElement(new Color(0, 0, 0));
        this.colors.addElement(new Color(255, 255, 255));
        this.trailingMessage = "(press any key to close this window)";
        this.messageIsShowing = false;
        this.messageToDraw = "";
        this.gameOver = false;
        this.repaint();
    }

    private void drawPinhole(Graphics graphics, int n, int n2) {
        Color color = (Color)this.colors.elementAt(this.guesses[n][n2]);
        if (color == null) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y, this.pinholeSize, this.pinholeSize);
        } else {
            graphics.setColor(color.red, color.green, color.blue);
            graphics.fillRect(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y, this.pinholeSize, this.pinholeSize);
            graphics.setColor(255, 255, 255);
            graphics.drawLine(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x + this.pinholeSize, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y);
            graphics.drawLine(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y + this.pinholeSize);
            graphics.setColor(0, 0, 0);
            graphics.drawLine(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y + this.pinholeSize, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x + this.pinholeSize, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y + this.pinholeSize);
            graphics.drawLine(((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x + this.pinholeSize, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).x + this.pinholeSize, ((PinholeRow)this.pinholeRows.elementAt((int)n)).getColumn((int)n2).y + this.pinholeSize);
        }
    }

    private void drawResults(Graphics graphics, int n) {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n2 = this.results[n][i];
            switch (n2) {
                case 0: {
                    graphics.setColor(180, 90, 0);
                    break;
                }
                case 1: {
                    graphics.setColor(0, 0, 0);
                    break;
                }
                case 2: {
                    graphics.setColor(255, 255, 255);
                }
            }
            graphics.fillRect(((ResultRow)this.resultRows.elementAt((int)n)).getPosition((int)i).x, ((ResultRow)this.resultRows.elementAt((int)n)).getPosition((int)i).y, this.resultSize, this.resultSize);
        }
    }

    private void drawGameboard(Graphics graphics) {
        graphics.setColor(193, 95, 0);
        graphics.fillRect(0, 0, this.width, this.height + 1);
        int n = this.height / this.numberOfRows;
        int n2 = this.width / (this.numberOfColumns + 2);
        int n3 = n2 * this.numberOfColumns;
        graphics.setColor(113, 51, 0);
        graphics.drawLine(n3, 0, n3, this.height);
        int n4 = n;
        int n5 = 0;
        while (n5 < this.numberOfRows) {
            graphics.setColor(113, 51, 0);
            graphics.drawLine(0, n4, this.width, n4);
            for (int i = 0; i < this.numberOfColumns; ++i) {
                this.drawPinhole(graphics, n5, i);
                if (n5 != this.currentRow || i != this.currentColumn) continue;
                graphics.setColor(0, 0, 255);
                graphics.drawRect(((PinholeRow)this.pinholeRows.elementAt((int)n5)).getColumn((int)i).x, ((PinholeRow)this.pinholeRows.elementAt((int)n5)).getColumn((int)i).y, this.pinholeSize, this.pinholeSize);
            }
            this.drawResults(graphics, n5);
            ++n5;
            n4 += n;
        }
    }

    private boolean evaluateGuess() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
            if (this.guesses[this.currentRow][n2] != 0) continue;
            this.messageToDraw = "You have to guess all colors.";
            return false;
        }
        for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                if (n2 == n || this.guesses[this.currentRow][n2] != this.guesses[this.currentRow][n]) continue;
                this.messageToDraw = "Don't guess duplicate colors.";
                return false;
            }
        }
        n2 = 0;
        for (n = 0; n < this.numberOfColumns; ++n) {
            if (this.guesses[this.currentRow][n] != (Integer)this.facit.elementAt(n)) continue;
            this.results[this.currentRow][n2] = 1;
            ++n2;
        }
        if (n2 == this.numberOfColumns) {
            this.trailingMessage = "(press any key to play again)";
            this.messageToDraw = "Congratulations, you made it!";
            this.gameOver = true;
            this.showFacit = true;
        } else {
            for (n = 0; n < this.numberOfColumns; ++n) {
                if (this.guesses[this.currentRow][n] == (Integer)this.facit.elementAt(n) || !this.facit.contains(new Integer(this.guesses[this.currentRow][n]))) continue;
                this.results[this.currentRow][n2] = 2;
                ++n2;
            }
        }
        if (this.currentRow == 0) {
            this.trailingMessage = "(press any key to play again)";
            this.messageToDraw = "Sorry, no win this time...";
            this.gameOver = true;
            this.showFacit = true;
        }
        return true;
    }

    private void drawFacit(Graphics graphics) {
        int n = this.width / 4;
        int n2 = this.height / 3 + 40;
        int n3 = this.width / 2 - 10;
        int n4 = 20;
        int n5 = n3 / this.numberOfColumns;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(n, n2, this.width / 2, 30);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(n, n2, this.width / 2, 30);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n6 = (Integer)this.facit.elementAt(i);
            Color color = (Color)this.colors.elementAt(n6);
            graphics.setColor(color.red, color.green, color.blue);
            graphics.fillRect(n + 5 + i * n5, n2 + 5, n5, n4);
        }
    }

    private void drawMessage(Graphics graphics) {
        String string;
        String string2;
        int n;
        Font font = Font.getFont((int)32, (int)0, (int)8);
        graphics.setFont(font);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(5, 5, this.width - 5, this.height - 5);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(5, 5, this.width - 5, this.height - 5);
        if (font.stringWidth(this.messageToDraw) > this.width - 10) {
            n = this.messageToDraw.indexOf(32, this.messageToDraw.length() / 2);
            string2 = this.messageToDraw.substring(0, n);
            string = this.messageToDraw.substring(n + 1, this.messageToDraw.length());
            graphics.drawString(string2, 7, 10, 20);
            graphics.drawString(string, 7, 12 + font.getHeight(), 20);
        } else {
            graphics.drawString(this.messageToDraw, 7, 10, 20);
        }
        graphics.setColor(160, 160, 160);
        if (font.stringWidth(this.trailingMessage) > this.width - 10) {
            n = this.trailingMessage.indexOf(32, this.trailingMessage.length() / 2);
            string2 = this.trailingMessage.substring(0, n);
            string = this.trailingMessage.substring(n + 1, this.trailingMessage.length());
            graphics.drawString(string2, 7, 10 + (2 + font.getHeight()) * 3, 20);
            graphics.drawString(string, 7, 10 + (2 + font.getHeight()) * 4, 20);
        } else {
            graphics.drawString(this.trailingMessage, 7, 10 + (2 + font.getHeight()) * 3, 20);
        }
        this.messageIsShowing = true;
    }

    public void paint(Graphics graphics) {
        this.drawGameboard(graphics);
        if (this.messageToDraw.compareTo("") != 0) {
            this.drawMessage(graphics);
        }
        if (this.showFacit) {
            this.drawFacit(graphics);
        }
    }

    public void guess() {
        if (this.evaluateGuess()) {
            --this.currentRow;
        }
        this.repaint();
    }

    protected void keyPressed(int n) {
        block15: {
            block13: {
                block14: {
                    if (this.gameOver) break block13;
                    if (this.messageIsShowing) break block14;
                    int n2 = this.getGameAction(n);
                    switch (n2) {
                        case 2: {
                            if (this.currentColumn > 0) {
                                --this.currentColumn;
                                this.repaint();
                                break;
                            }
                            break block15;
                        }
                        case 5: {
                            if (this.currentColumn < this.numberOfColumns - 1) {
                                ++this.currentColumn;
                                this.repaint();
                                break;
                            }
                            break block15;
                        }
                        case 1: {
                            if (this.guesses[this.currentRow][this.currentColumn] < this.numberOfBalls) {
                                int[] nArray = this.guesses[this.currentRow];
                                int n3 = this.currentColumn;
                                nArray[n3] = nArray[n3] + 1;
                            } else {
                                this.guesses[this.currentRow][this.currentColumn] = 0;
                            }
                            this.repaint();
                            break;
                        }
                        case 6: {
                            if (this.guesses[this.currentRow][this.currentColumn] > 0) {
                                int[] nArray = this.guesses[this.currentRow];
                                int n4 = this.currentColumn;
                                nArray[n4] = nArray[n4] - 1;
                            } else {
                                this.guesses[this.currentRow][this.currentColumn] = this.numberOfBalls;
                            }
                            this.repaint();
                            break;
                        }
                        case 8: {
                            break;
                        }
                    }
                    break block15;
                }
                this.messageIsShowing = false;
                this.messageToDraw = "";
                this.repaint();
                break block15;
            }
            this.initGame(this.numberOfRows, this.numberOfColumns, this.numberOfBalls);
            this.repaint();
        }
    }
}

