/*
 * Decompiled with CFR 0.152.
 */
package org.phoneid.keepassinstaller;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import org.phoneid.keepassinstaller.KDBFilter;

public final class KeePassInstaller
implements Runnable {
    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new KeePassInstaller());
    }

    @Override
    public void run() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new KDBFilter());
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getCurrentDirectory();
                File file2 = jFileChooser.getSelectedFile();
                System.out.println(file2.getAbsolutePath());
                this.copyFile(file2.getAbsolutePath(), "Database.kdb");
            } else {
                System.err.println("Cannot open file");
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void copyFile(String string, String string2) throws IOException {
        FileChannel fileChannel = new FileInputStream(string).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(string2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        fileChannel.close();
        fileChannel2.close();
    }

    public void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void createJar(String string, String string2) throws IOException {
        this.copyFile(string, string2);
        FileInputStream fileInputStream = new FileInputStream("META-INF/MANIFEST.MF");
        FileOutputStream fileOutputStream = new FileOutputStream("KeePassJ2ME-kdb.jar");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest(fileInputStream));
        JarEntry jarEntry = new JarEntry(string2);
        jarOutputStream.putNextEntry(jarEntry);
        FileInputStream fileInputStream2 = new FileInputStream(string2);
        this.copyStream(fileInputStream2, jarOutputStream);
        fileInputStream2.close();
        jarOutputStream.close();
    }
}

