/*
 * Decompiled with CFR 0.152.
 */
package Kana;

import Kana.KanaCard;
import java.util.Random;

class KanaCardStore {
    static final int NumCards = 73;
    public KanaCard[] card;
    public int numCards = 0;
    private int curCard;
    private int[] order;
    private Random r = new Random();

    public int Match(String s) {
        String us = s.toUpperCase();
        int i = 0;
        while (i != this.numCards) {
            if (us.startsWith(this.card[i].Meaning().toUpperCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int Rand() {
        int z = this.r.nextInt() % this.numCards;
        if (z < 0) {
            z = -z;
        }
        return z;
    }

    private void Shake() {
        int i;
        for (i = 0; i < this.numCards; ++i) {
            this.order[i] = i;
        }
        for (i = 0; i < 200; ++i) {
            int a = this.Rand();
            int b = this.Rand();
            int temp = this.order[a];
            this.order[a] = this.order[b];
            this.order[b] = temp;
        }
    }

    public KanaCardStore() {
        this.card = new KanaCard[74];
        this.order = new int[74];
        this.InitCard("/H3064tsu.png", "tsu");
        this.InitCard("/H3061chi.png", "chi");
        this.InitCard("/H3057si.png", "shi");
        this.InitCard("/H304Bka.png", "ka");
        this.InitCard("/H304Cga.png", "ga");
        this.InitCard("/H304Dki.png", "ki");
        this.InitCard("/H304Egi.png", "gi");
        this.InitCard("/H304Fku.png", "ku");
        this.InitCard("/H3050gu.png", "gu");
        this.InitCard("/H3051ke.png", "ke");
        this.InitCard("/H3052ge.png", "ge");
        this.InitCard("/H3053ko.png", "ko");
        this.InitCard("/H3054go.png", "go");
        this.InitCard("/H3055sa.png", "sa");
        this.InitCard("/H3056za.png", "za");
        this.InitCard("/H3058zi.png", "ji");
        this.InitCard("/H3059su.png", "su");
        this.InitCard("/H305Azu.png", "zu");
        this.InitCard("/H305Bse.png", "se");
        this.InitCard("/H305Cze.png", "ze");
        this.InitCard("/H305Dso.png", "so");
        this.InitCard("/H305Ezo.png", "zo");
        this.InitCard("/H305Fta.png", "ta");
        this.InitCard("/H3060da.png", "da");
        this.InitCard("/H3062di.png", "di");
        this.InitCard("/H3065du.png", "zu");
        this.InitCard("/H3066te.png", "te");
        this.InitCard("/H3067de.png", "de");
        this.InitCard("/H3068to.png", "to");
        this.InitCard("/H3069do.png", "do");
        this.InitCard("/H306Ana.png", "na");
        this.InitCard("/H306Bni.png", "ni");
        this.InitCard("/H306Cnu.png", "nu");
        this.InitCard("/H306Dne.png", "ne");
        this.InitCard("/H306Eno.png", "no");
        this.InitCard("/H306Fha.png", "ha");
        this.InitCard("/H3070ba.png", "ba");
        this.InitCard("/H3071pa.png", "pa");
        this.InitCard("/H3072hi.png", "hi");
        this.InitCard("/H3073bi.png", "bi");
        this.InitCard("/H3074pi.png", "pi");
        this.InitCard("/H3075hu.png", "fu");
        this.InitCard("/H3076bu.png", "bu");
        this.InitCard("/H3077pu.png", "pu");
        this.InitCard("/H3078he.png", "he");
        this.InitCard("/H3079be.png", "be");
        this.InitCard("/H307Ape.png", "pe");
        this.InitCard("/H307Bho.png", "ho");
        this.InitCard("/H307Cbo.png", "bo");
        this.InitCard("/H307Dpo.png", "po");
        this.InitCard("/H307Ema.png", "ma");
        this.InitCard("/H307Fmi.png", "mi");
        this.InitCard("/H3080mu.png", "mu");
        this.InitCard("/H3081me.png", "me");
        this.InitCard("/H3082mo.png", "mo");
        this.InitCard("/H3084ya.png", "ya");
        this.InitCard("/H3086yu.png", "yu");
        this.InitCard("/H3088yo.png", "yo");
        this.InitCard("/H3089ra.png", "ra");
        this.InitCard("/H3090wi.png", "wi");
        this.InitCard("/H3091we.png", "we");
        this.InitCard("/H308Ari.png", "ri");
        this.InitCard("/H308Bru.png", "ru");
        this.InitCard("/H308Cre.png", "re");
        this.InitCard("/H308Dro.png", "ro");
        this.InitCard("/H3094vu.png", "vu");
        this.InitCard("/H308Fwa.png", "wa");
        this.InitCard("/H3092wo.png", "wo");
        this.InitCard("/H3093n.png", "n");
        this.InitCard("/H3042a.png", "a");
        this.InitCard("/H3044i.png", "i");
        this.InitCard("/H3046u.png", "u");
        this.InitCard("/H3048e.png", "e");
        this.InitCard("/H304Ao.png", "o");
    }

    private void InitCard(String fileName, String name) {
        this.card[this.numCards] = new KanaCard(fileName, name);
        ++this.numCards;
    }

    public KanaCard FirstCard() {
        this.Shake();
        this.curCard = 0;
        return this.NextCard();
    }

    public KanaCard NextCard() {
        if (this.curCard >= this.numCards) {
            return null;
        }
        ++this.curCard;
        return this.card[this.order[this.curCard - 1]];
    }
}

