/*
 * Decompiled with CFR 0.152.
 */
package Kana;

import Kana.KanaCard;
import Kana.KanaCardStore;
import Kana.KanaMIDlet;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class KanaCanvas
extends Canvas
implements CommandListener {
    static final int AskPhase = 0;
    static final int AnswerPhase = 1;
    static final int WritePhase = 2;
    private KanaMIDlet mMidlet;
    private KanaCardStore mCardStore;
    private Command exitCommand;
    private Command revealCommand;
    private Command nextCommand;
    private KanaCard curCard;
    private Command yesCommand;
    private Command noCommand;
    private Command newStringCommand;
    private Command okCommand;
    private int curPhase;
    private String mString;
    public int yesCounter;
    public int noCounter;
    public int yesNoCounter;
    public Font largeFont;

    private void InitCanvas(KanaMIDlet midlet, KanaCardStore cardStore) {
        this.mMidlet = midlet;
        this.mCardStore = cardStore;
        this.largeFont = Font.getFont((int)64, (int)1, (int)16);
        this.exitCommand = new Command("Exit", 7, 0);
        this.nextCommand = new Command("Next", 1, 0);
        this.revealCommand = new Command("Reveal", 1, 0);
        this.yesCommand = new Command("Yes", 1, 0);
        this.noCommand = new Command("No", 2, 0);
        this.newStringCommand = new Command("Again", 1, 0);
        this.setCommandListener(this);
    }

    public KanaCanvas(KanaMIDlet midlet, KanaCardStore cardStore) {
        this.InitCanvas(midlet, cardStore);
        this.addCommand(this.exitCommand);
        this.addCommand(this.revealCommand);
        this.curCard = cardStore.FirstCard();
        this.curPhase = 0;
    }

    public KanaCanvas(KanaMIDlet midlet, KanaCardStore cardStore, String s) {
        this.InitCanvas(midlet, cardStore);
        this.mString = s;
        this.addCommand(this.exitCommand);
        this.addCommand(this.newStringCommand);
        this.curPhase = 2;
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.revealCommand) {
            this.curPhase = 1;
            this.removeCommand(this.revealCommand);
            this.removeCommand(this.exitCommand);
            this.addCommand(this.yesCommand);
            this.addCommand(this.noCommand);
            this.repaint();
        } else if (c == this.yesCommand) {
            ++this.yesCounter;
            this.curCard = this.mCardStore.NextCard();
            if (this.curCard != null) {
                this.curPhase = 0;
                this.removeCommand(this.yesCommand);
                this.removeCommand(this.noCommand);
                this.addCommand(this.exitCommand);
                this.addCommand(this.revealCommand);
                this.repaint();
            } else {
                this.mMidlet.ShowExit();
            }
        } else if (c == this.noCommand) {
            ++this.noCounter;
            this.curCard = this.mCardStore.NextCard();
            if (this.curCard != null) {
                this.curPhase = 0;
                this.removeCommand(this.yesCommand);
                this.removeCommand(this.noCommand);
                this.addCommand(this.exitCommand);
                this.addCommand(this.revealCommand);
                this.repaint();
            } else {
                this.mMidlet.ShowExit();
            }
        } else if (c == this.newStringCommand) {
            this.mMidlet.str.setString("");
            this.mMidlet.display.setCurrent((Displayable)this.mMidlet.writeForm);
        } else if (c == this.exitCommand) {
            if (this.curPhase == 2) {
                this.mMidlet.exitMIDlet();
            } else {
                this.mMidlet.ShowExit();
            }
        }
    }

    public void WriteHiragana(Graphics g, String s) {
        int x = 0;
        int y = 10;
        g.setColor(0, 0, 0);
        StringBuffer b = new StringBuffer(s);
        while (b.length() != 0) {
            int num = this.mCardStore.Match(b.toString());
            if (num == -1) {
                g.drawChar(b.charAt(0), x, y + 16, 20);
                x += g.getFont().charWidth(b.charAt(0));
                b.delete(0, 1);
            } else {
                this.mCardStore.card[num].Draw(g, x, y, true);
                x += 32;
                b.delete(0, this.mCardStore.card[num].Meaning().length());
            }
            if (x + 32 <= this.getWidth()) continue;
            y = y + 32 + 15;
            x = 0;
        }
    }

    protected void paint(Graphics g) {
        Font savedFont = g.getFont();
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(this.largeFont);
        if (this.curPhase == 2) {
            this.WriteHiragana(g, this.mString);
            g.setFont(savedFont);
        } else {
            g.setColor(0, 0, 0);
            g.drawString("" + (this.yesCounter + this.noCounter + 1) + ":", 10, 0, 20);
            this.curCard.Draw(g, this.getWidth() / 2 - 16, 0, this.curPhase == 1);
            g.setFont(savedFont);
            if (this.curPhase == 1) {
                int h = savedFont.getHeight();
                g.drawString("Did you know it?", this.getWidth() / 2, g.getClipHeight() - h - 5, 17);
            }
        }
    }
}

