/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import java.util.Random;
import javax.microedition.lcdui.Graphics;

public final class StarWay3D {
    OneStar[] StarField;
    int StarCount;
    int MidX;
    int MidY;
    boolean ColoredDisp;

    public StarWay3D(int Cnt, int cx, int cy, boolean bColored) {
        this.MidX = cx >> 1;
        this.MidY = cy >> 1;
        this.ColoredDisp = bColored;
        this.StarCount = Cnt;
        this.StarField = new OneStar[this.StarCount];
        Random RndGenerator = new Random();
        RndGenerator.setSeed(180576L);
        for (int i = 0; i < this.StarCount; ++i) {
            this.StarField[i] = new OneStar();
            this.StarField[i].x = Math.abs(RndGenerator.nextInt()) % cx - this.MidX;
            this.StarField[i].y = Math.abs(RndGenerator.nextInt()) % cy - this.MidY;
            this.StarField[i].z = (Math.abs(RndGenerator.nextInt()) & 0x7F) + 1;
        }
    }

    public final void Paint(Graphics gfx) {
        for (int i = 0; i < this.StarCount; ++i) {
            this.StarField[i].Remove(gfx, this.MidX, this.MidY);
            if ((this.StarField[i].z -= 3) < 1) {
                this.StarField[i].z = 127;
            }
            this.StarField[i].Draw(gfx, this.MidX, this.MidY, this.ColoredDisp);
        }
    }

    private final class OneStar {
        int x = 0;
        int y = 0;
        int z = 1;

        public void Draw(Graphics gfx, int cx, int cy, boolean bColored) {
            int ax = (this.x << 7) / this.z + cx;
            int ay = (this.y << 7) / this.z + cy;
            int az = (128 - this.z) / 24;
            int cl = bColored ? 64 + ((127 - this.z) * 3 >> 1) : 255;
            gfx.setColor(cl, cl, cl);
            if (az > 0) {
                gfx.drawLine(ax, ay - az, ax, ay + az);
                gfx.drawLine(ax - az, ay, ax + az, ay);
            } else {
                gfx.drawLine(ax, ay, ax, ay);
            }
        }

        public void Remove(Graphics gfx, int cx, int cy) {
            int ax = (this.x << 7) / this.z + cx;
            int ay = (this.y << 7) / this.z + cy;
            int az = (128 - this.z) / 24;
            gfx.setColor(0);
            if (az > 0) {
                gfx.fillRect(ax - az, ay - az, (az << 1) + 1, (az << 1) + 1);
            } else {
                gfx.drawLine(ax, ay, ax, ay);
            }
        }
    }
}

