/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.dustdigger.DiggerLevels;
import overthehill.dustdigger.DiggerSound;
import overthehill.dustdigger.JoyPad;

public final class DiggerPlayfield {
    private int BobsPerCol;
    private int BobsPerRow;
    private int LeftBorder;
    private int RightBorder;
    private int TopBorder;
    private int BottomBorder;
    private int LevelNum;
    private int PlayerLives;
    private int PlayerOffset;
    private int Diamonds;
    private int KeyFound;
    private int RestartDelay;
    private int FlickerMode;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int InternalState;
    private int BlinkCounter;
    private int BlkImgPerRow;
    private final SimplePoint ScrollOffset = new SimplePoint();
    private final SimplePoint PlayerRel = new SimplePoint();
    private final SimplePoint StylusPos = new SimplePoint();
    private final SimplePoint OldStylusPos = new SimplePoint();
    private final SimplePoint Difference = new SimplePoint();
    private final Image BlockImage;
    private final Image SymbImage;
    private final DiggerSound SoundPlayer;
    private static final int AbsLevelCols = 28;
    private static final int AbsLevelRows = 28;
    private static final int GravSpeed = 200;
    private int BlockXSize;
    private int BlockYSize;
    private int SymbXSize;
    private int SymbYSize;
    private char[] Playfield;
    private char[][] SnapShot;
    private int GlenzIndex;
    private static final char[] GlenzTable = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000'};
    private int LavaIndex;
    private int LavaTimer;
    private static final char[] LavaTable = new char[]{'\u001c', '\u0001', '\u0001', '\u0001', '\u001c', '\u0001', '\u001c', '\u001c', '\u0001', '\u0001'};

    public DiggerPlayfield(Image dImage, Image dSymbols, DiggerSound dSound, int dWidth, int dHeight, int pXBlkSize, int pYBlkSize, int pXSymSize, int pYSymSize) {
        this.BlockImage = dImage;
        this.SymbImage = dSymbols;
        this.SoundPlayer = dSound;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.Playfield = new char[785];
        if (this.Playfield != null) {
            this.ResetGameVars();
            this.InternalState = 0;
            this.BlockYSize = pXBlkSize;
            this.BlockXSize = pYBlkSize;
            this.SymbXSize = pXSymSize;
            this.SymbYSize = pYSymSize;
            this.BobsPerRow = dWidth / this.BlockXSize;
            if (this.BobsPerRow > 28) {
                this.BobsPerRow = 28;
            }
            if ((this.BobsPerCol = dHeight / this.BlockYSize) > 28) {
                this.BobsPerCol = 28;
            }
            int i = this.BobsPerRow * this.BlockXSize;
            this.LeftBorder = dWidth - i >> 1;
            this.RightBorder = dWidth - (this.LeftBorder + i);
            i = this.BobsPerCol * this.BlockYSize;
            this.TopBorder = dHeight - i >> 1;
            this.BottomBorder = dHeight - (this.TopBorder + i);
            this.BlkImgPerRow = this.BlockImage.getWidth() / this.BlockXSize;
            this.PrepareLevel();
            this.SnapShot = new char[this.BobsPerRow][this.BobsPerCol];
            this.ResetSnapShotTable();
        }
    }

    public final void BuildPlayfield(Graphics gfx) {
        if (gfx != null) {
            gfx.setColor(0);
            if (this.LeftBorder > 0) {
                int sze = this.PlayfieldHeight - (this.TopBorder + this.BottomBorder);
                gfx.fillRect(0, this.TopBorder, this.LeftBorder, sze);
                gfx.fillRect(this.PlayfieldWidth - this.RightBorder, this.TopBorder, this.RightBorder, sze);
            }
            if (this.TopBorder > 0) {
                gfx.fillRect(0, 0, this.PlayfieldWidth, this.TopBorder);
                gfx.fillRect(0, this.PlayfieldHeight - this.BottomBorder, this.PlayfieldWidth, this.BottomBorder);
            }
            if (++this.BlinkCounter > 6) {
                this.BlinkCounter = 1;
            }
            this.PaintPlayfield(gfx);
            if (this.InternalState != 5) {
                if (this.RestartDelay <= 0) {
                    if (JoyPad.IsAnyKey()) {
                        this.StylusPos.x = this.PlayerOffset % 28 - this.ScrollOffset.x;
                        this.StylusPos.y = this.PlayerOffset / 28 - this.ScrollOffset.y;
                        if (JoyPad.IsLeftKey()) {
                            --this.StylusPos.x;
                        }
                        if (JoyPad.IsRightKey()) {
                            ++this.StylusPos.x;
                        }
                        if (JoyPad.IsUpKey()) {
                            --this.StylusPos.y;
                        }
                        if (JoyPad.IsDownKey()) {
                            ++this.StylusPos.y;
                        }
                        this.MovePlayer();
                    }
                    this.CheckGravity();
                    this.MoveMonster();
                    this.CheckCollision();
                } else if (--this.RestartDelay == 0) {
                    this.ReStartLevel();
                }
            } else {
                this.DrawFinalInformation(gfx);
            }
        }
    }

    private final void PaintPlayfield(Graphics gfx) {
        if (gfx != null) {
            int PlOffset = this.ScrollOffset.y * 28 + this.ScrollOffset.x;
            int XSymbPos = this.LeftBorder + 2;
            int YSymbPos = this.TopBorder + 2;
            int lives = this.PlayerLives;
            if (this.FlickerMode == 0) {
                int YDestPos = this.TopBorder;
                for (int yindex = 0; yindex < this.BobsPerCol; ++yindex) {
                    int XDestPos = this.LeftBorder;
                    for (int xindex = 0; xindex < this.BobsPerRow; ++xindex) {
                        int BlockId = this.Playfield[PlOffset++] - 65;
                        switch (BlockId) {
                            case 5: {
                                if (GlenzTable[this.GlenzIndex++] != '\u0000') {
                                    BlockId = 16;
                                }
                                if (this.GlenzIndex < GlenzTable.length) break;
                                this.GlenzIndex = 0;
                                break;
                            }
                            case 18: {
                                if (this.BlinkCounter > 3) break;
                                BlockId = 6;
                            }
                        }
                        int XSourceOff = BlockId % this.BlkImgPerRow * this.BlockXSize;
                        int YSourceOff = BlockId / this.BlkImgPerRow * this.BlockYSize;
                        if (this.SnapShot[xindex][yindex] != (char)BlockId || lives != 0) {
                            gfx.setClip(XDestPos, YDestPos, this.BlockXSize, this.BlockYSize);
                            gfx.drawImage(this.BlockImage, XDestPos - XSourceOff, YDestPos - YSourceOff, 20);
                        }
                        XDestPos += this.BlockXSize;
                        if (lives != 0 && this.SymbImage != null) {
                            do {
                                gfx.setClip(XSymbPos, YSymbPos, this.SymbXSize, this.SymbYSize);
                                gfx.drawImage(this.SymbImage, XSymbPos, YSymbPos, 20);
                            } while (--lives != 0 && (XSymbPos += this.SymbXSize) + this.SymbXSize < XDestPos);
                        }
                        this.SnapShot[xindex][yindex] = (char)BlockId;
                    }
                    PlOffset += 28 - this.BobsPerRow;
                    YDestPos += this.BlockYSize;
                }
                gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
            } else {
                gfx.setColor(0xFFFFFF);
                gfx.fillRect(this.LeftBorder, this.TopBorder, this.BlockXSize * this.BobsPerRow, this.BlockYSize * this.BobsPerCol);
                this.ResetSnapShotTable();
                --this.FlickerMode;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void CheckGravity() {
        int PlIdx = this.Playfield.length - 28 - 2;
        while (PlIdx > 28) {
            switch (this.Playfield[PlIdx]) {
                case 'A': {
                    char EId;
                    switch (this.Playfield[PlIdx + 28]) {
                        case 'N': {
                            if (this.Playfield[PlIdx + 56] != 'G') break;
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 56] = 70;
                            break;
                        }
                        case 'G': {
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 28] = 65;
                            EId = this.Playfield[PlIdx + 56];
                            if (EId == 'D' || EId == 'E' || EId == 'H') {
                                this.LoseLive();
                                this.Playfield[PlIdx + 56] = 76;
                            }
                            if (EId == 'G' || this.RestartDelay != 0) break;
                            this.PlaySound(65);
                            break;
                        }
                        case 'J': 
                        case 'K': {
                            this.Playfield[PlIdx + 28] = 70;
                            this.PlaySound(67);
                            break;
                        }
                        case 'A': 
                        case 'F': 
                        case 'S': {
                            if (this.Playfield[PlIdx + 28 - 1] == 'G' && this.Playfield[PlIdx - 1] == 'G') {
                                this.Playfield[PlIdx] = 71;
                                this.Playfield[PlIdx + 28 - 1] = 65;
                                if (this.Playfield[PlIdx + 56 - 1] != 'G') {
                                    this.PlaySound(65);
                                }
                                if ((EId = this.Playfield[PlIdx + 56 - 1]) == 'D' || EId == 'E' || EId == 'H') {
                                    this.LoseLive();
                                    this.Playfield[PlIdx + 56 - 1] = 76;
                                }
                            }
                            if (this.Playfield[PlIdx + 28 + 1] != 'G' || this.Playfield[PlIdx + 1] != 'G') break;
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 28 + 1] = 65;
                            if (this.Playfield[PlIdx + 56 + 1] != 'G') {
                                this.PlaySound(65);
                            }
                            if ((EId = this.Playfield[PlIdx + 56 + 1]) != 'D' && EId != 'E' && EId != 'H') break;
                            this.LoseLive();
                            this.Playfield[PlIdx + 56 + 1] = 76;
                            break;
                        }
                    }
                    break;
                }
                case 'F': {
                    char EId;
                    switch (this.Playfield[PlIdx + 28]) {
                        case 'N': {
                            if (this.Playfield[PlIdx + 56] != 'G') break;
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 56] = 65;
                            break;
                        }
                        case 'G': {
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 28] = 70;
                            EId = this.Playfield[PlIdx + 56];
                            if (EId == 'D' || EId == 'E' || EId == 'H') {
                                this.LoseLive();
                                this.Playfield[PlIdx + 56] = 76;
                            }
                            if (EId == 'G' || this.RestartDelay != 0) break;
                            this.PlaySound(66);
                            break;
                        }
                        case 'J': 
                        case 'K': {
                            this.Playfield[PlIdx + 28] = 70;
                            this.PlaySound(67);
                            break;
                        }
                        case 'A': 
                        case 'F': 
                        case 'S': {
                            if (this.Playfield[PlIdx + 28 - 1] == 'G' && this.Playfield[PlIdx - 1] == 'G') {
                                this.Playfield[PlIdx] = 71;
                                this.Playfield[PlIdx + 28 - 1] = 70;
                                if (this.Playfield[PlIdx + 56 - 1] != 'G') {
                                    this.PlaySound(66);
                                }
                                if ((EId = this.Playfield[PlIdx + 56 - 1]) == 'D' || EId == 'E' || EId == 'H') {
                                    this.LoseLive();
                                    this.Playfield[PlIdx + 56 - 1] = 76;
                                }
                            }
                            if (this.Playfield[PlIdx + 28 + 1] != 'G' || this.Playfield[PlIdx + 1] != 'G') break;
                            this.Playfield[PlIdx] = 71;
                            this.Playfield[PlIdx + 28 + 1] = 70;
                            if (this.Playfield[PlIdx + 56 + 1] != 'G') {
                                this.PlaySound(66);
                            }
                            if ((EId = this.Playfield[PlIdx + 56 + 1]) != 'D' && EId != 'E' && EId != 'H') break;
                            this.LoseLive();
                            this.Playfield[PlIdx + 56 + 1] = 76;
                        }
                    }
                    break;
                }
            }
            --PlIdx;
        }
        return;
    }

    private final void LoseLive() {
        if (--this.PlayerLives == 0) {
            this.RestartDelay = 20;
            this.InternalState = 4;
        } else {
            this.RestartDelay = 10;
        }
        this.PlaySound(128);
        JoyPad.ResetAllKeys();
    }

    private final void OpenGate() {
        for (int idx = 0; idx < this.Playfield.length; ++idx) {
            if (this.Playfield[idx] == 'O') {
                this.Playfield[idx] = 80;
            }
            this.FlickerMode = 3;
        }
    }

    private final void DiamondCollected() {
        this.PlaySound(68);
        if (--this.Diamonds == 0) {
            this.OpenGate();
        }
    }

    private final void KeyCollected() {
        this.PlaySound(68);
        ++this.KeyFound;
    }

    private final boolean UseKeyOnDoor() {
        if (this.KeyFound > 0) {
            this.PlaySound(69);
            --this.KeyFound;
            return true;
        }
        return false;
    }

    private final void PrepareLevel() {
        this.KeyFound = 0;
        this.LavaIndex = 0;
        this.LavaTimer = 0;
        this.PlayerOffset = 29;
        if (this.LevelNum <= DiggerLevels.GetLevelCount()) {
            this.Playfield = DiggerLevels.GetLevelCharArray(this.LevelNum);
            this.Diamonds = DiggerLevels.GetLevelDiamonds(this.LevelNum);
            for (int idx = 0; idx < this.Playfield.length; ++idx) {
                switch (this.Playfield[idx]) {
                    case 'H': {
                        this.PlayerOffset = idx;
                    }
                    case 'M': {
                        this.LavaTimer = 1;
                    }
                }
            }
        }
        this.InternalState = 3;
    }

    private final void MovePlayer() {
        this.PlayerRel.x = this.PlayerOffset % 28;
        this.PlayerRel.y = this.PlayerOffset / 28;
        this.Difference.x = this.StylusPos.x - (this.PlayerRel.x - this.ScrollOffset.x);
        this.Difference.y = this.StylusPos.y - (this.PlayerRel.y - this.ScrollOffset.y);
        if (this.Difference.y >= 1 && this.Difference.y <= 3) {
            char chr = this.Playfield[this.PlayerOffset + 28];
            if (chr == 'B' || chr == 'F' || chr == 'G' || chr == 'S') {
                switch (chr) {
                    case 'F': {
                        this.DiamondCollected();
                        break;
                    }
                    case 'S': {
                        this.KeyCollected();
                    }
                }
                this.Playfield[this.PlayerOffset] = 71;
                this.PlayerOffset += 28;
                this.Playfield[this.PlayerOffset] = 72;
                if (this.ScrollOffset.y < 28 - this.BobsPerCol && this.PlayerRel.y - this.ScrollOffset.y > this.BobsPerCol / 2 - 1) {
                    ++this.ScrollOffset.y;
                }
                return;
            }
            if (chr == 'T' && this.UseKeyOnDoor()) {
                this.Playfield[this.PlayerOffset + 28] = 71;
            }
            return;
        }
        if (this.Difference.y <= -1 && this.Difference.y >= -3) {
            char chr = this.Playfield[this.PlayerOffset - 28];
            if (chr == 'B' || chr == 'F' || chr == 'G' || chr == 'S') {
                switch (chr) {
                    case 'F': {
                        this.DiamondCollected();
                        break;
                    }
                    case 'S': {
                        this.KeyCollected();
                    }
                }
                this.Playfield[this.PlayerOffset] = 71;
                this.PlayerOffset -= 28;
                this.Playfield[this.PlayerOffset] = 72;
                if (this.ScrollOffset.y > 0 && this.PlayerRel.y - this.ScrollOffset.y < this.BobsPerCol / 2 + 1) {
                    --this.ScrollOffset.y;
                }
                return;
            }
            if (chr == 'T' && this.UseKeyOnDoor()) {
                this.Playfield[this.PlayerOffset - 28] = 71;
            }
            return;
        }
        if (this.Difference.x <= -1 && this.Difference.x >= -3) {
            int chr = this.Playfield[this.PlayerOffset - 1];
            if (chr == 65 && this.Playfield[this.PlayerOffset - 2] == 'G') {
                this.Playfield[this.PlayerOffset - 2] = 65;
                chr = 71;
                this.CheckGravity();
                this.PlaySound(69);
            }
            if (chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                switch (chr) {
                    case 70: {
                        this.DiamondCollected();
                        break;
                    }
                    case 83: {
                        this.KeyCollected();
                    }
                }
                this.Playfield[this.PlayerOffset] = 71;
                --this.PlayerOffset;
                this.Playfield[this.PlayerOffset] = 69;
                if (this.ScrollOffset.x > 0 && this.PlayerRel.x - this.ScrollOffset.x < this.BobsPerRow / 2 + 1) {
                    --this.ScrollOffset.x;
                }
                return;
            }
            if (chr == 84 && this.UseKeyOnDoor()) {
                this.Playfield[this.PlayerOffset - 1] = 71;
            }
            return;
        }
        if (this.Difference.x >= 1 && this.Difference.x <= 3) {
            int chr = this.Playfield[this.PlayerOffset + 1];
            if (chr == 65 && this.Playfield[this.PlayerOffset + 2] == 'G') {
                this.Playfield[this.PlayerOffset + 2] = 65;
                chr = 71;
                this.CheckGravity();
                this.PlaySound(69);
            }
            if (chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                switch (chr) {
                    case 70: {
                        this.DiamondCollected();
                        break;
                    }
                    case 83: {
                        this.KeyCollected();
                    }
                }
                this.Playfield[this.PlayerOffset] = 71;
                ++this.PlayerOffset;
                this.Playfield[this.PlayerOffset] = 68;
                if (this.ScrollOffset.x < 28 - this.BobsPerRow && this.PlayerRel.x - this.ScrollOffset.x >= this.BobsPerRow / 2) {
                    ++this.ScrollOffset.x;
                }
                return;
            }
            if (chr == 84 && this.UseKeyOnDoor()) {
                this.Playfield[this.PlayerOffset + 1] = 71;
            }
        }
    }

    private final void MoveMonster() {
        char nchr;
        int cbase;
        int cindex;
        block9: for (cindex = 29; cindex < this.Playfield.length - 28 - 1; ++cindex) {
            switch (this.Playfield[cindex]) {
                case 'R': {
                    this.Playfield[cindex] = 77;
                    continue block9;
                }
                case 'M': {
                    this.Playfield[cindex] = 82;
                    if (this.LavaTimer == 0 || --this.LavaTimer != 0) continue block9;
                    cbase = cindex - LavaTable[this.LavaIndex];
                    nchr = this.Playfield[cbase];
                    if (nchr != 'C' && nchr != 'I') {
                        this.Playfield[cbase] = 77;
                    }
                    if (++this.LavaIndex >= LavaTable.length) {
                        this.LavaIndex = 0;
                    }
                    this.LavaTimer = 60000 / (200 + LavaTable[this.LavaIndex]);
                    continue block9;
                }
                case 'J': {
                    cbase = cindex - 28;
                    nchr = this.Playfield[cbase];
                    if (nchr == 'M' || nchr == 'R') {
                        this.Playfield[cindex] = 70;
                        continue block9;
                    }
                    if (nchr == 'G') {
                        this.Playfield[cindex] = 71;
                        this.Playfield[cbase] = 74;
                        if (this.Playfield[cbase - 1] != 'G') continue block9;
                        this.Playfield[cbase] = 71;
                        this.Playfield[cbase - 1] = 74;
                        continue block9;
                    }
                    if (this.Playfield[cindex + 1] == 'G') {
                        this.Playfield[cindex] = 71;
                        this.Playfield[cindex + 1] = 74;
                        ++cindex;
                        continue block9;
                    }
                    this.Playfield[cindex] = 75;
                }
            }
        }
        block10: for (cindex = this.Playfield.length - 28 - 2; cindex > 28; --cindex) {
            switch (this.Playfield[cindex]) {
                case 'M': {
                    if (this.LavaTimer == 0) continue block10;
                    if (--this.LavaTimer == 0 && (nchr = this.Playfield[cbase = cindex + LavaTable[this.LavaIndex]]) != 'C' && nchr != 'I') {
                        this.Playfield[cbase] = 77;
                    }
                    if (++this.LavaIndex >= LavaTable.length) {
                        this.LavaIndex = 0;
                    }
                    this.LavaTimer = 35000 / (200 + LavaTable[this.LavaIndex]);
                    continue block10;
                }
                case 'K': {
                    cbase = cindex + 28;
                    nchr = this.Playfield[cbase];
                    if (nchr == 'M' || nchr == 'R') {
                        this.Playfield[cindex] = 70;
                        continue block10;
                    }
                    if (nchr == 'G') {
                        this.Playfield[cindex] = 71;
                        this.Playfield[cbase] = 75;
                        if (this.Playfield[cbase + 1] != 'G') continue block10;
                        this.Playfield[cbase] = 71;
                        this.Playfield[cbase + 1] = 75;
                        continue block10;
                    }
                    if (this.Playfield[cindex - 1] == 'G') {
                        this.Playfield[cindex] = 71;
                        this.Playfield[cindex - 1] = 75;
                        --cindex;
                        continue block10;
                    }
                    this.Playfield[cindex] = 74;
                }
            }
        }
    }

    private final void CheckCollision() {
        boolean Hunted = false;
        char chr1 = this.Playfield[this.PlayerOffset];
        if (chr1 == 'M' || chr1 == 'R') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset + 1]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset - 1]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset + 28]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset - 28]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if (chr1 == 'P') {
            if (this.LevelNum >= DiggerLevels.GetLevelCount() - 1) {
                this.InternalState = 5;
            } else {
                ++this.LevelNum;
                this.ScrollOffset.x = 0;
                this.ScrollOffset.y = 0;
                this.PrepareLevel();
            }
            return;
        }
        if (Hunted) {
            this.Playfield[this.PlayerOffset] = 76;
            this.LoseLive();
        }
    }

    private final void ReStartLevel() {
        this.ScrollOffset.x = 0;
        this.ScrollOffset.y = 0;
        this.OldStylusPos.x = 0;
        this.OldStylusPos.y = 0;
        this.PlayerRel.x = 0;
        this.PlayerRel.y = 0;
        if (this.PlayerLives == 0) {
            this.ResetGameVars();
        }
        this.PrepareLevel();
    }

    public final void StylusRelease() {
        this.OldStylusPos.x = (this.PlayerOffset % 28 - this.ScrollOffset.x) * this.BlockXSize + (this.BlockXSize >> 1);
        this.OldStylusPos.y = (this.PlayerOffset / 28 - this.ScrollOffset.y) * this.BlockYSize + (this.BlockYSize >> 1);
    }

    public final void StylusMove(int StylusX, int StylusY) {
        if (this.InternalState == 3 && this.RestartDelay == 0) {
            this.StylusPos.x = StylusX - this.LeftBorder;
            this.StylusPos.y = StylusY - this.TopBorder;
            if (this.StylusPos.x > 0 && this.StylusPos.x < this.PlayfieldWidth - this.LeftBorder && this.StylusPos.y > 0 && this.StylusPos.y < this.PlayfieldHeight - this.TopBorder) {
                int StylusXDifference = this.OldStylusPos.x - this.StylusPos.x;
                int StylusYDifference = this.OldStylusPos.y - this.StylusPos.y;
                if (StylusXDifference > 8 || StylusXDifference < -8 || StylusYDifference > 8 || StylusYDifference < -8) {
                    this.OldStylusPos.x = this.StylusPos.x;
                    this.OldStylusPos.y = this.StylusPos.y;
                    this.StylusPos.x /= this.BlockXSize;
                    this.StylusPos.y /= this.BlockYSize;
                    int PlayerAbsPosX = this.PlayerRel.x - this.ScrollOffset.x;
                    int PlayerAbsPosY = this.PlayerRel.y - this.ScrollOffset.y;
                    if (StylusXDifference > 0 && this.StylusPos.x <= PlayerAbsPosX || StylusXDifference < 0 && this.StylusPos.x >= PlayerAbsPosX || StylusYDifference > 0 && this.StylusPos.y <= PlayerAbsPosY || StylusYDifference < 0 && this.StylusPos.y >= PlayerAbsPosY) {
                        if (StylusXDifference > 8 && this.StylusPos.x <= PlayerAbsPosX || StylusXDifference < -8 && this.StylusPos.x >= PlayerAbsPosX) {
                            this.StylusPos.y = this.PlayerOffset / 28 - this.ScrollOffset.y;
                        } else if (StylusYDifference > 8 && this.StylusPos.y <= PlayerAbsPosY || StylusYDifference < -8 && this.StylusPos.y >= PlayerAbsPosY) {
                            this.StylusPos.x = this.PlayerOffset % 28 - this.ScrollOffset.x;
                        }
                        if (this.PlayerOffset != this.ScrollOffset.x + this.StylusPos.x + (this.ScrollOffset.y + this.StylusPos.y) * 28) {
                            this.MovePlayer();
                        }
                    }
                }
            }
        }
    }

    private final void PlaySound(int SoundIdx) {
        if (this.SoundPlayer != null) {
            this.SoundPlayer.PlaySound(SoundIdx);
        }
    }

    private final void DrawFinalInformation(Graphics gfx) {
        int i;
        int[] LTable = new int[]{20, 50, 70};
        String[] STable = new String[]{"*Gratulation*", "Mission", "completed!"};
        gfx.setColor(0);
        int c = this.PlayfieldWidth - this.LeftBorder;
        for (i = this.TopBorder + this.PlayfieldHeight - 2; i > this.TopBorder; i -= 2) {
            gfx.drawLine(this.LeftBorder, i, c, i);
        }
        c = this.PlayfieldHeight - this.TopBorder;
        for (i = this.LeftBorder + this.PlayfieldWidth - 2; i > this.LeftBorder; i -= 2) {
            gfx.drawLine(i, this.TopBorder, i, c);
        }
        gfx.setColor(255, 255, 255);
        c = this.PlayfieldWidth >> 1;
        for (i = 0; i < LTable.length; ++i) {
            gfx.drawString(STable[i], c, this.PlayfieldHeight * LTable[i] / 100, 17);
        }
    }

    private final void ResetGameVars() {
        this.GlenzIndex = 0;
        this.FlickerMode = 0;
        this.Diamonds = 0;
        this.LevelNum = 0;
        this.LavaIndex = 0;
        this.LavaTimer = 0;
        this.PlayerLives = 5;
        this.RestartDelay = 0;
        this.KeyFound = 0;
        this.BlinkCounter = 1;
    }

    private final void ResetSnapShotTable() {
        if (this.SnapShot != null) {
            for (int yindex = 0; yindex < this.BobsPerCol; ++yindex) {
                for (int xindex = 0; xindex < this.BobsPerRow; ++xindex) {
                    this.SnapShot[xindex][yindex] = 120;
                }
            }
        }
    }

    public final void RestoreAllNotification() {
        this.ResetSnapShotTable();
        JoyPad.ResetAllKeys();
        this.OldStylusPos.x = 0;
        this.OldStylusPos.y = 0;
    }

    private final class SimplePoint {
        int x = 0;
        int y = 0;

        SimplePoint() {
        }
    }
}

