/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import overthehill.dustdigger.DiggerGame;

public final class DiggerMain
extends Canvas
implements Runnable,
CommandListener {
    private final Command cmdStart = new Command("Start", 4, 1);
    private final Command cmdExit = new Command("Exit", 4, 1);
    private MIDlet BaseMidlet;
    private DiggerGame GameCore;
    private Image OffScreenImage;
    private int GameState = 0;
    private int GameLoopDelay = 100;
    private int PlayfieldWidth = this.getWidth();
    private int PlayfieldHeight = this.getHeight();
    private long DebounceItemTimer = System.currentTimeMillis();

    public DiggerMain(MIDlet rmidlet, boolean ColoredDisp) {
        this.BaseMidlet = rmidlet;
        this.OffScreenImage = this.isDoubleBuffered() ? null : Image.createImage((int)this.PlayfieldWidth, (int)this.PlayfieldHeight);
        this.addCommand(this.cmdStart);
        this.setCommandListener(this);
        this.GameCore = new DiggerGame(this, "/overthehill/dustdigger", this.PlayfieldWidth, this.PlayfieldHeight, ColoredDisp);
        this.GameState = 1;
    }

    public final void paint(Graphics gfx) {
        Graphics OffScreenGfx = gfx;
        if (this.OffScreenImage != null) {
            OffScreenGfx = this.OffScreenImage.getGraphics();
        }
        switch (this.GameState) {
            case 1: {
                this.GameLoopDelay = 50;
                gfx.setColor(0);
                gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
                this.GameState = 2;
                break;
            }
            case 2: {
                this.GameLoopDelay = 50;
                this.GameCore.PaintTitle(OffScreenGfx);
                break;
            }
            case 3: {
                this.GameLoopDelay = 150;
                this.GameCore.PaintGame(OffScreenGfx);
                break;
            }
        }
        if (this.OffScreenImage != null) {
            gfx.setClip(0, 0, this.OffScreenImage.getWidth(), this.OffScreenImage.getHeight());
            gfx.drawImage(this.OffScreenImage, 0, 0, 20);
        }
    }

    public final void keyPressed(int code) {
        switch (this.getGameAction(code)) {
            case 1: {
                this.GameCore.MoveUp(true);
                break;
            }
            case 6: {
                this.GameCore.MoveDown(true);
                break;
            }
            case 2: {
                this.GameCore.MoveLeft(true);
                break;
            }
            case 5: {
                this.GameCore.MoveRight(true);
                break;
            }
        }
    }

    public final void keyReleased(int code) {
        switch (this.getGameAction(code)) {
            case 1: {
                this.GameCore.MoveUp(false);
                break;
            }
            case 6: {
                this.GameCore.MoveDown(false);
                break;
            }
            case 2: {
                this.GameCore.MoveLeft(false);
                break;
            }
            case 5: {
                this.GameCore.MoveRight(false);
                break;
            }
        }
    }

    public final void pointerDragged(int x, int y) {
        this.GameCore.StylusMove(x, y);
    }

    public final void pointerPressed(int x, int y) {
        if (this.GameState == 2) {
            this.GameState = 3;
        }
    }

    public final void pointerReleased(int x, int y) {
        this.GameCore.StylusRelease();
    }

    public final void showNotify() {
        this.DebounceItemTimer = System.currentTimeMillis();
        switch (this.GameState) {
            case 2: {
                this.GameState = 1;
                break;
            }
            case 3: {
                this.GameCore.NotifyGameInterupption();
                break;
            }
        }
    }

    public final void hideNotify() {
    }

    public final void run() {
        while (this.GameState != 6) {
            long loopStartTime = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            Thread.yield();
            long loopEndTime = System.currentTimeMillis();
            int loopTime = (int)(loopEndTime - loopStartTime);
            if (loopTime >= this.GameLoopDelay) continue;
            try {
                Thread.sleep(this.GameLoopDelay - loopTime);
            }
            catch (InterruptedException ie) {}
        }
    }

    public final void DestroyGame() {
        this.GameState = 6;
        this.GameCore.DestroyCore();
    }

    public final void commandAction(Command ncmd, Displayable ndisp) {
        long CurrentTimeInMillis = System.currentTimeMillis();
        if (CurrentTimeInMillis - this.DebounceItemTimer > 1000L) {
            this.DebounceItemTimer = CurrentTimeInMillis;
            try {
                if (ncmd == this.cmdStart) {
                    this.GameState = 3;
                    this.removeCommand(this.cmdStart);
                    this.addCommand(this.cmdExit);
                }
                if (ncmd == this.cmdExit) {
                    this.DestroyGame();
                    this.BaseMidlet.notifyDestroyed();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public final class CoreState {
        public static final int STATE_INIT = 0;
        public static final int STATE_PREPARE = 1;
        public static final int STATE_TITLE = 2;
        public static final int STATE_GAME = 3;
        public static final int STATE_OVER = 4;
        public static final int STATE_FINAL = 5;
        public static final int STATE_DESTROY = 6;
    }
}

