/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.dustdigger.DiggerMain;
import overthehill.dustdigger.DiggerPlayfield;
import overthehill.dustdigger.DiggerSound;
import overthehill.dustdigger.JoyPad;
import overthehill.dustdigger.StarWay3D;

public final class DiggerGame {
    private Image TitleImage;
    private Image BlockImage;
    private Image SymbolImage;
    private final StarWay3D TitleStars;
    private final DiggerPlayfield GamePlayfield;
    private final DiggerSound GameSound;
    private final DiggerMain BaseCanvas;
    private int TitleHeight;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int WelcomeDirect;
    private int LastWelcomeIndex;
    private static final String[] WelcomeTexts = new String[]{"A classic for", "your mobile.", "Idea and Coding", "Roy Schneider", "Copyright \u00a92005", "Roy Schneider", "This game is", "FREEWARE!", "If you like it,", "e-mail me.", "royspa@", "overthehill.de"};

    public DiggerGame(DiggerMain rCanvas, String GameRootPath, int dWidth, int dHeight, boolean ColoredDisp) {
        int BlockXSize = 0;
        int BlockYSize = 0;
        int SymbXSize = 0;
        int SymbYSize = 0;
        this.BaseCanvas = rCanvas;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.LastWelcomeIndex = 0;
        this.WelcomeDirect = 0;
        try {
            String GfxRootPath = new String(GameRootPath);
            GfxRootPath = GfxRootPath + "/images";
            GfxRootPath = GfxRootPath + "/small";
            BlockXSize = 16;
            BlockYSize = 16;
            SymbXSize = 8;
            SymbYSize = 8;
            this.TitleHeight = 15;
            if (!ColoredDisp) {
                GfxRootPath = GfxRootPath + "/bw";
            }
            this.TitleImage = Image.createImage((String)(GfxRootPath + "/title.png"));
            this.BlockImage = Image.createImage((String)(GfxRootPath + "/blocks.png"));
            if (ColoredDisp) {
                this.SymbolImage = Image.createImage((String)(GfxRootPath + "/syms.png"));
            }
        }
        catch (IOException e) {
            this.BaseCanvas.DestroyGame();
        }
        this.TitleStars = new StarWay3D(48, this.PlayfieldWidth, this.PlayfieldHeight, ColoredDisp);
        this.GameSound = null;
        this.GamePlayfield = new DiggerPlayfield(this.BlockImage, this.SymbolImage, this.GameSound, this.PlayfieldWidth, this.PlayfieldHeight, BlockXSize, BlockYSize, SymbXSize, SymbYSize);
        if (this.CheckForManipulation()) {
            this.BaseCanvas.DestroyGame();
        }
    }

    public final void DestroyCore() {
        if (this.GameSound != null) {
            this.GameSound.Destroy();
        }
    }

    public final void PaintTitle(Graphics gfx) {
        if (gfx != null) {
            int FontHeight = gfx.getFont().getHeight();
            this.TitleStars.Paint(gfx);
            gfx.drawImage(this.TitleImage, this.PlayfieldWidth >> 1, (this.PlayfieldHeight >> 2) - (this.TitleHeight >> 1), 17);
            int WelcomeIndex = this.WelcomeDirect >> 4 & 0xFE;
            int WelcomeColor = (this.WelcomeDirect & 0xF) + 1;
            WelcomeColor = (this.WelcomeDirect & 0x10) == 0 ? (WelcomeColor > 7 ? 0xFFFFFF : WelcomeColor * 0x222222) : (WelcomeColor > 15 ? 0 : 0xFFFFFF - WelcomeColor * 0x111111);
            int CursorLineA = (this.PlayfieldHeight * 77 >> 7) - (FontHeight >> 1);
            int CursorLineB = (this.PlayfieldHeight * 96 >> 7) - (FontHeight >> 1);
            if (CursorLineB < CursorLineA + FontHeight + 2) {
                CursorLineB = CursorLineA + FontHeight + 2;
            }
            gfx.setColor(WelcomeColor);
            gfx.drawString(WelcomeTexts[WelcomeIndex], this.PlayfieldWidth >> 1, CursorLineA, 17);
            gfx.drawString(WelcomeTexts[WelcomeIndex + 1], this.PlayfieldWidth >> 1, CursorLineB, 17);
            if (++this.WelcomeDirect >= WelcomeTexts.length << 4) {
                this.WelcomeDirect = 0;
            }
            this.LastWelcomeIndex = WelcomeIndex;
        }
    }

    public final void PaintGame(Graphics gfx) {
        this.GamePlayfield.BuildPlayfield(gfx);
    }

    public final void MoveLeft(boolean KeyState) {
        JoyPad.SetLeftKeyState(KeyState);
    }

    public final void MoveRight(boolean KeyState) {
        JoyPad.SetRightKeyState(KeyState);
    }

    public final void MoveUp(boolean KeyState) {
        JoyPad.SetUpKeyState(KeyState);
    }

    public final void MoveDown(boolean KeyState) {
        JoyPad.SetDownKeyState(KeyState);
    }

    public final void StylusRelease() {
        this.GamePlayfield.StylusRelease();
    }

    public final void StylusMove(int StylusX, int StylusY) {
        this.GamePlayfield.StylusMove(StylusX, StylusY);
    }

    private final int CalcTextCheckSum() {
        int CheckSum = 0;
        for (int tline = 0; tline < WelcomeTexts.length; ++tline) {
            int textlen = WelcomeTexts[tline].length();
            while (textlen-- != 0) {
                CheckSum += WelcomeTexts[tline].charAt(textlen);
            }
        }
        return CheckSum;
    }

    private final boolean CheckForManipulation() {
        return this.CalcTextCheckSum() != 13642 || this.TitleImage.getHeight() != this.TitleHeight;
    }

    public final void NotifyGameInterupption() {
        this.GamePlayfield.RestoreAllNotification();
    }
}

