/*
 * Decompiled with CFR 0.152.
 */
package chessstress;

import chess.Coordinate;
import chess.Game;
import chess.Move;
import java.util.Enumeration;
import java.util.Vector;

public class MoveController {
    private boolean[][] selectable = new boolean[8][8];
    private Coordinate target;
    private Coordinate source;
    private Game game;

    public MoveController() {
    }

    public MoveController(Game game) {
        this.setNothingSelectable();
        this.game = game;
        this.startOver();
    }

    public void startOver() {
        this.source = null;
        this.target = null;
        this.setStonesSelectable();
    }

    public Coordinate getSource() {
        return this.source;
    }

    public boolean isMoveChoosen() {
        return this.target != null && this.source != null;
    }

    public Move getMove() {
        if (this.isMoveChoosen()) {
            return new Move(this.source, this.target);
        }
        return null;
    }

    public synchronized void fieldClicked(Coordinate c) {
        if (!this.isSelectable(c)) {
            return;
        }
        if (this.source != null) {
            if (this.source.equals(c)) {
                this.startOver();
                return;
            }
            this.target = c;
            this.setNothingSelectable();
        } else {
            this.source = c;
            this.target = null;
            this.setTargetsSelectable(this.game.getMoveList(this.source));
        }
    }

    private void setStonesSelectable() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean val;
                Coordinate c = new Coordinate(i, j);
                boolean bl = val = this.game.getStone(c) != null && this.game.getStone(c).getColor() == this.game.getCurColor();
                if (!val) continue;
                this.selectable[i][j] = true;
            }
        }
    }

    private void setTargetsSelectable(Vector targetList) {
        this.setNothingSelectable();
        targetList.addElement(this.source);
        Enumeration enumeration = targetList.elements();
        while (enumeration.hasMoreElements()) {
            Coordinate c = (Coordinate)enumeration.nextElement();
            this.selectable[c.getX()][c.getY()] = true;
        }
        targetList.removeElement(this.source);
    }

    private void setNothingSelectable() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.selectable[i][j] = false;
            }
        }
    }

    public boolean isSelectable(Coordinate c) {
        return this.selectable[c.getX()][c.getY()];
    }

    public boolean isTargetSearch() {
        return this.target == null && this.source != null;
    }
}

