/*
 * Decompiled with CFR 0.152.
 */
package chessstress;

import chess.Coordinate;
import chess.Game;
import chess.Move;
import chess.Stone;
import chessstress.Backable;
import chessstress.BlinkClock;
import chessstress.ImageContainer;
import chessstress.Message;
import chessstress.MoveController;
import chessstress.PeonQuestion;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardScreen
extends Canvas
implements CommandListener,
Backable {
    public static BoardScreen thisInstance;
    private static final Command[] COMMANDS;
    private static Display display;
    private static Backable winBack;
    Game game;
    MoveController ctrl;
    Coordinate cursor = new Coordinate(7, 0);
    ImageContainer imgs = new ImageContainer();
    Graphics graph;
    boolean isDone = false;
    int fx = 10;
    int fy = 12;

    public BoardScreen(Display disp) {
        thisInstance = this;
        for (int i = 0; i < COMMANDS.length; ++i) {
            this.addCommand(COMMANDS[i]);
        }
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                this.commandAction(c, d);
            }
        });
        this.game = new Game(new PeonQuestion(disp, this), false);
        this.ctrl = new MoveController(this.game);
        BlinkClock.start(600, this);
        BlinkClock.continueBlink();
    }

    protected void paint(Graphics g) {
        Graphics graphics = g;
        synchronized (graphics) {
            this.graph = g;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    Coordinate c = new Coordinate(i, j);
                    this.drawField(c);
                }
            }
        }
        if (this.game.getCurColor() == 1) {
            this.graph.setColor(0);
        } else {
            this.graph.setColor(255, 255, 255);
        }
        g.fillRect(97, 0, 101, 75);
    }

    private void drawField(Coordinate c) {
        this.graph.setColor(0);
        Image image = null;
        int i = c.getX();
        int j = c.getY();
        Stone s = this.game.getStone(c);
        if (s == null) {
            if ((i + j) % 2 == 1) {
                this.graph.fillRect(j * 12, i * 10, this.fy, this.fx);
            } else {
                this.graph.setColor(255, 255, 255);
                this.graph.fillRect(j * 12, i * 10, this.fy, this.fx);
                this.graph.setColor(0);
            }
        } else {
            image = this.imgs.getImage(s.getType(), s.getColor(), (i + j) % 2);
            if (image != null) {
                this.graph.drawImage(image, j * 12, i * 10, 0);
            }
        }
    }

    public void drawBlinking(int mode) {
        this.drawBlinking(this.cursor, mode);
        Coordinate source = this.ctrl.getSource();
        if (source != null) {
            this.drawBlinking(source, mode);
        }
    }

    private void drawBlinking(Coordinate c, int mode) {
        boolean x;
        if (display.getCurrent() != this) {
            return;
        }
        if (this.graph == null) {
            return;
        }
        boolean bl = x = (c.getX() + c.getY()) % 2 == 1;
        if (mode == 0 && x || mode == 1 && !x) {
            this.graph.setColor(255, 255, 255);
        } else {
            this.graph.setColor(0);
        }
        this.graph.drawRect(c.getY() * 12, c.getX() * 10, this.fy - 1, this.fx - 1);
    }

    protected void hideNotify() {
        BlinkClock.stopBlink();
    }

    protected void showNotify() {
        BlinkClock.continueBlink();
    }

    protected synchronized void keyPressed(int keyCode) {
        BlinkClock.continueBlink();
        int key = this.getExtraAction(keyCode);
        switch (key) {
            case 1: {
                this.newMove(-1, 0);
                break;
            }
            case 6: {
                this.newMove(1, 0);
                break;
            }
            case 2: {
                this.newMove(0, -1);
                break;
            }
            case 5: {
                this.newMove(0, 1);
                break;
            }
            case 49: {
                this.newMove(-1, -1);
                break;
            }
            case 51: {
                this.newMove(-1, 1);
                break;
            }
            case 57: {
                this.newMove(1, 1);
                break;
            }
            case 55: {
                this.newMove(1, -1);
                break;
            }
            case 8: {
                BlinkClock.stopBlink();
                this.ctrl.fieldClicked(this.cursor);
                if (this.ctrl.isMoveChoosen()) {
                    Move mv = this.ctrl.getMove();
                    int col = this.game.getCurColor();
                    this.game.setMove(mv);
                    String player = "WHITE";
                    if (this.game.getCurColor() == 1) {
                        player = "BLACK";
                    }
                    if (col == this.game.getCurColor()) {
                        new Message(String.valueOf(String.valueOf(new StringBuffer("Illegal Move \n").append(player).append(" is in CHECK!")))).show(display, this);
                    } else {
                        this.checkStatus();
                    }
                    this.ctrl.startOver();
                    this.repaint();
                }
                BlinkClock.continueBlink();
            }
        }
    }

    private int getExtraAction(int keyCode) {
        int key = keyCode;
        switch (keyCode) {
            case 49: {
                break;
            }
            case 51: {
                break;
            }
            case 57: {
                break;
            }
            case 55: {
                break;
            }
            case 52: {
                key = 2;
                break;
            }
            case 54: {
                key = 5;
                break;
            }
            case 53: {
                key = 8;
                break;
            }
            case 56: {
                key = 6;
                break;
            }
            case 50: {
                key = 1;
                break;
            }
            default: {
                key = this.getGameAction(keyCode);
            }
        }
        return key;
    }

    private void newMove(int x, int y) {
        Coordinate c = this.cursor.getNewPos(x, y);
        if (c.isValid()) {
            this.drawField(this.cursor);
            this.cursor = c;
            this.paint(this.graph);
        }
    }

    public void show(Display disp, Backable goBack) {
        display = disp;
        winBack = goBack;
        disp.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    public void show() {
        display.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable obj) {
        if (cmd == COMMANDS[1]) {
            winBack.show();
        } else if (cmd == COMMANDS[3]) {
            if (!this.game.takeBackMove()) {
                new Message("Not Possible!").show(display, this);
            } else {
                this.ctrl.startOver();
                this.repaint();
            }
        } else if (cmd == COMMANDS[2]) {
            if (!this.game.RedoLastMove()) {
                new Message("Not Possible").show(display, this);
            } else {
                this.ctrl.startOver();
                this.repaint();
            }
        } else {
            this.repaint();
        }
    }

    public void checkStatus() {
        String player = "WHITE";
        if (this.game.getCurColor() == 1) {
            player = "BLACK";
        }
        if (this.game.getStatus() == 5) {
            new Message(String.valueOf(String.valueOf(player)).concat(" is in CHECK!")).show(display, this);
        } else if (this.game.getStatus() == 1) {
            new Message(String.valueOf(String.valueOf(player)).concat(" lost!\nCHECKMATE")).show(display, this);
        } else if (this.game.getStatus() == 2) {
            new Message("Game over\nPATT").show(display, this);
        }
    }

    public static void repaintBoard() {
        thisInstance.checkStatus();
        thisInstance.repaint();
    }

    static {
        COMMANDS = new Command[]{new Command("Continue", 3, 1), new Command("End Game", 6, 2), new Command("Redo Move", 8, 3), new Command("Undo Move", 8, 4)};
    }
}

