/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Configuration;
import chess.Coordinate;
import chess.Move;
import chess.Stone;
import java.util.Vector;

public class StoneRook
extends Stone {
    public StoneRook(int color) {
        super(3, color);
    }

    public Vector getMoveList(Coordinate c, Configuration conf) {
        Vector list = new Vector();
        this.movesEven(list, c, conf);
        return list;
    }

    public Vector getAttackList(Coordinate c, BoardMap board) {
        Vector list = new Vector();
        this.attacksEven(list, c, board);
        return list;
    }

    public void movesEven(Vector list, Coordinate c, Configuration conf) {
        BoardMap board = conf.getBoardMap();
        block6: for (int i = 0; i < 4; ++i) {
            Coordinate pos;
            int x = 0;
            int y = 0;
            int xx = 0;
            int yy = 0;
            switch (i) {
                case 0: {
                    x = 1;
                    y = 0;
                    break;
                }
                case 1: {
                    x = 0;
                    y = 1;
                    break;
                }
                case 2: {
                    x = -1;
                    y = 0;
                    break;
                }
                case 3: {
                    x = 0;
                    y = -1;
                }
            }
            for (int j = 0; j < 7 && board.isInBoardBorders(pos = c.getNewPos(xx += x, yy += y)); ++j) {
                if (board.isNotSameColor(pos, this.getColor()) && !this.isCheckAfterMove(conf, new Move(c, pos))) {
                    list.addElement(pos);
                }
                if (board.getStone(pos) != null) continue block6;
            }
        }
    }

    public void attacksEven(Vector list, Coordinate c, BoardMap board) {
        block6: for (int i = 0; i < 4; ++i) {
            Coordinate pos;
            int x = 0;
            int y = 0;
            int xx = 0;
            int yy = 0;
            switch (i) {
                case 0: {
                    x = 1;
                    y = 0;
                    break;
                }
                case 1: {
                    x = 0;
                    y = 1;
                    break;
                }
                case 2: {
                    x = -1;
                    y = 0;
                    break;
                }
                case 3: {
                    x = 0;
                    y = -1;
                }
            }
            for (int j = 0; j < 7 && board.isInBoardBorders(pos = c.getNewPos(xx += x, yy += y)); ++j) {
                list.addElement(pos);
                if (board.getStone(pos) != null) continue block6;
            }
        }
    }
}

