/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Configuration;
import chess.Coordinate;
import chess.InfoMap;
import chess.Move;
import chess.Stone;
import java.util.Vector;

public class StonePeon
extends Stone {
    public StonePeon(int color) {
        super(0, color);
    }

    public Vector getAttackList(Coordinate c, BoardMap board) {
        Vector<Coordinate> list = new Vector<Coordinate>();
        int aSide = 1;
        for (int i = 0; i < 2; ++i) {
            Coordinate pos = c.getNewPos(this.getColor(), aSide);
            if (board.isInBoardBorders(pos)) {
                list.addElement(pos);
            }
            aSide *= -1;
        }
        return list;
    }

    public Vector getMoveList(Coordinate c, Configuration conf) {
        Vector<Coordinate> list = new Vector<Coordinate>();
        BoardMap board = conf.getBoardMap();
        InfoMap info = conf.getInfoMap();
        int aSide = 1;
        for (int i = 0; i < 2; ++i) {
            Coordinate pos = c.getNewPos(this.getColor(), aSide);
            if (board.isInBoardBorders(pos) && (board.isNotSameColor(pos, this.getColor()) && board.getStone(pos) != null || info.getInfo(pos) == 2) && !this.isCheckAfterMove(conf, new Move(c, pos))) {
                list.addElement(pos);
            }
            aSide *= -1;
        }
        Coordinate pos = c.getNewPos(this.getColor(), 0);
        if (board.isInBoardBorders(pos) && board.getStone(pos) == null) {
            Move move;
            if (!this.isCheckAfterMove(conf, new Move(c, pos))) {
                list.addElement(pos);
            }
            if (conf.isPeon2StepAllowed(move = new Move(c, pos = pos.getNewPos(this.getColor(), 0))) && !this.isCheckAfterMove(conf, move)) {
                list.addElement(pos);
            }
        }
        return list;
    }
}

