/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Configuration;
import chess.Coordinate;
import chess.InfoMap;
import chess.Move;
import chess.Stone;
import java.util.Vector;

public class StoneKing
extends Stone {
    public StoneKing(int color) {
        super(5, color);
    }

    public Vector getAttackList(Coordinate c, BoardMap board) {
        Vector<Coordinate> list = new Vector<Coordinate>();
        for (int i = 0; i < 8; ++i) {
            int x = 0;
            int y = 0;
            switch (i) {
                case 0: {
                    x = 0;
                    y = -1;
                    break;
                }
                case 1: {
                    x = 0;
                    y = 1;
                    break;
                }
                case 2: {
                    x = 1;
                    y = 0;
                    break;
                }
                case 3: {
                    x = 1;
                    y = 1;
                    break;
                }
                case 4: {
                    x = -1;
                    y = 1;
                    break;
                }
                case 5: {
                    x = 1;
                    y = -1;
                    break;
                }
                case 6: {
                    x = -1;
                    y = 0;
                    break;
                }
                case 7: {
                    x = -1;
                    y = -1;
                }
            }
            Coordinate pos = new Coordinate(c.getX() + x, c.getY() + y);
            if (!board.isInBoardBorders(pos)) continue;
            list.addElement(pos);
        }
        return list;
    }

    public Vector getMoveList(Coordinate c, Configuration conf) {
        Coordinate _f;
        Coordinate _g;
        Coordinate _d;
        Coordinate _c;
        Coordinate _b;
        BoardMap board = conf.getBoardMap();
        InfoMap info = conf.getInfoMap();
        Vector<Coordinate> list = new Vector<Coordinate>();
        for (int i = 0; i < 8; ++i) {
            int x = 0;
            int y = 0;
            switch (i) {
                case 0: {
                    x = 0;
                    y = -1;
                    break;
                }
                case 1: {
                    x = 0;
                    y = 1;
                    break;
                }
                case 2: {
                    x = 1;
                    y = 0;
                    break;
                }
                case 3: {
                    x = 1;
                    y = 1;
                    break;
                }
                case 4: {
                    x = -1;
                    y = 1;
                    break;
                }
                case 5: {
                    x = 1;
                    y = -1;
                    break;
                }
                case 6: {
                    x = -1;
                    y = 0;
                    break;
                }
                case 7: {
                    x = -1;
                    y = -1;
                }
            }
            Coordinate pos = new Coordinate(c.getX() + x, c.getY() + y);
            if (!board.isInBoardBorders(pos) || !board.isNotSameColor(pos, this.getColor()) || this.isCheckAfterMove(conf, new Move(c, pos))) continue;
            list.addElement(pos);
        }
        System.out.println("Rochade: Player : ".concat(String.valueOf(String.valueOf(this.getColor()))));
        if (conf.getStatus() == 5) {
            return list;
        }
        System.out.println("Rochade: King not under Attack");
        if (info.getInfo(c) != 1) {
            return list;
        }
        System.out.println("Rochade: King not touched");
        int row = this.getColor() == -1 ? 7 : 0;
        if (info.getInfo(new Coordinate(row, 0)) == 1 && board.getStone(_b = new Coordinate(row, 1)) == null && board.getStone(_c = new Coordinate(row, 2)) == null && board.getStone(_d = new Coordinate(row, 3)) == null && !conf.getAttackMap().isUnderAttack(_d)) {
            list.addElement(_c);
        }
        if (info.getInfo(new Coordinate(row, 7)) == 1 && board.getStone(_g = new Coordinate(row, 6)) == null && board.getStone(_f = new Coordinate(row, 5)) == null && !conf.getAttackMap().isUnderAttack(_f)) {
            list.addElement(_g);
        }
        return list;
    }
}

