/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Configuration;
import chess.Coordinate;
import chess.Move;
import chess.Stone;
import java.util.Vector;

public class StoneHorse
extends Stone {
    public StoneHorse(int color) {
        super(2, color);
    }

    public Vector getAttackList(Coordinate c, BoardMap board) {
        Vector<Coordinate> list = new Vector<Coordinate>();
        for (int i = 0; i < 2; ++i) {
            int horizontal = 1 + i;
            int vertical = 2 - i;
            int hSign = 1;
            int vSign = 1;
            for (int j = 0; j < 4; ++j) {
                hSign = j % 2 * -1 + (j + 1) % 2;
                vSign = j / 2 * -1 + (3 - j) / 2;
                int x = horizontal * hSign;
                int y = vertical * vSign;
                Coordinate pos = new Coordinate(c.getX() + x, c.getY() + y);
                if (!board.isInBoardBorders(pos)) continue;
                list.addElement(pos);
            }
        }
        return list;
    }

    public Vector getMoveList(Coordinate c, Configuration conf) {
        Vector<Coordinate> list = new Vector<Coordinate>();
        BoardMap board = conf.getBoardMap();
        for (int i = 0; i < 2; ++i) {
            int horizontal = 1 + i;
            int vertical = 2 - i;
            int hSign = 1;
            int vSign = 1;
            for (int j = 0; j < 4; ++j) {
                hSign = j % 2 * -1 + (j + 1) % 2;
                vSign = j / 2 * -1 + (3 - j) / 2;
                int x = horizontal * hSign;
                int y = vertical * vSign;
                Coordinate pos = new Coordinate(c.getX() + x, c.getY() + y);
                if (!board.isInBoardBorders(pos) || !board.isNotSameColor(pos, this.getColor()) || this.isCheckAfterMove(conf, new Move(c, pos))) continue;
                list.addElement(pos);
            }
        }
        return list;
    }
}

