/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Configuration;
import chess.Coordinate;
import chess.Enviroment;
import chess.Move;
import java.util.Vector;

public abstract class Stone
extends Enviroment {
    private int color;
    private int type;
    private static boolean isChecking = true;

    public static void setChecking(boolean _isChecking) {
        isChecking = _isChecking;
    }

    public Stone(int type, int color) {
        this.type = type;
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String preFix = null;
        String name = "";
        switch (this.type) {
            case 0: {
                name = "PEON";
                break;
            }
            case 1: {
                name = "BISHOP";
                break;
            }
            case 2: {
                name = "HORSE";
                break;
            }
            case 3: {
                name = "ROOK";
                break;
            }
            case 4: {
                name = "QUEEN";
                break;
            }
            case 5: {
                name = "KING";
            }
        }
        preFix = this.color == 1 ? "BLACK_" : "WHITE_";
        return String.valueOf(String.valueOf(preFix)).concat(String.valueOf(String.valueOf(name)));
    }

    public abstract Vector getAttackList(Coordinate var1, BoardMap var2);

    public abstract Vector getMoveList(Coordinate var1, Configuration var2);

    public boolean isCheckAfterMove(Configuration conf, Move move) {
        if (!isChecking) {
            return false;
        }
        Configuration newConf = conf.setMove(move, false);
        return newConf == null;
    }
}

