/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.Configuration;
import chess.Coordinate;
import chess.Enviroment;
import chess.Stone;
import java.util.Vector;

public class MoveMap
extends Enviroment {
    private Vector[][] moves = new Vector[8][8];
    boolean isMovePossible = false;

    public MoveMap(Configuration conf) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Coordinate c = new Coordinate(i, j);
                Vector list = this.getMoveList(c, conf);
                if (list == null || list.size() <= 0) continue;
                this.isMovePossible = true;
                break;
            }
            if (this.isMovePossible) break;
        }
    }

    public boolean isMovePossible() {
        return this.isMovePossible;
    }

    public Vector getMoveList(Coordinate c, Configuration conf) {
        Vector list = this.moves[c.getX()][c.getY()];
        if (list != null) {
            return list;
        }
        Stone stone = conf.getBoardMap().getStone(c);
        if (stone == null) {
            return null;
        }
        if (stone.getColor() != conf.getCurColor()) {
            return null;
        }
        this.moves[c.getX()][c.getY()] = list = stone.getMoveList(c, conf);
        return list;
    }
}

