/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.Coordinate;
import chess.Enviroment;
import chess.Move;

public class InfoMap
extends Enviroment {
    int[][] info = new int[8][8];

    public void setInfo(int inf, Coordinate c) {
        this.info[c.getX()][c.getY()] = inf;
    }

    public int getInfo(Coordinate c) {
        return this.info[c.getX()][c.getY()];
    }

    public static InfoMap createInitInfoMap() {
        InfoMap i = new InfoMap();
        for (int j = 0; j < 2; ++j) {
            int peonRow;
            int othersRow;
            if (j == 0) {
                othersRow = 7;
                peonRow = 6;
            } else {
                othersRow = 0;
                peonRow = 1;
            }
            for (int k = 0; k < 8; ++k) {
                i.setInfo(1, new Coordinate(peonRow, k));
                i.setInfo(1, new Coordinate(othersRow, k));
            }
        }
        return i;
    }

    public InfoMap setMove(Move move) {
        InfoMap i = new InfoMap();
        for (int k = 0; k < 8; ++k) {
            for (int j = 0; j < 8; ++j) {
                Coordinate c = new Coordinate(k, j);
                int inf = this.getInfo(c);
                if (inf != 1) {
                    inf = 0;
                }
                i.setInfo(inf, c);
            }
        }
        i.setInfo(0, move.getTarget());
        i.setInfo(0, move.getSource());
        return i;
    }
}

