/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.Configuration;
import chess.Coordinate;
import chess.Enviroment;
import chess.Move;
import chess.QuestionInterface;
import chess.Stone;
import java.util.Vector;

public class Game
extends Enviroment {
    private Vector list = new Vector();
    boolean isChecking = true;
    private int amount = 0;

    public Game(Configuration conf, QuestionInterface quest, boolean isChecking) {
        this.list.addElement(conf);
        Configuration.setQuestionObj(quest);
        this.isChecking = isChecking;
    }

    public Game(Vector list, QuestionInterface quest, boolean isChecking) {
        this.list = list;
        Configuration.setQuestionObj(quest);
        this.isChecking = isChecking;
        this.amount = list.size();
    }

    public Game(QuestionInterface quest, boolean isChecking) {
        this.isChecking = isChecking;
        Configuration start = this.getStartConfiguration();
        this.list.addElement(start);
        Configuration.setQuestionObj(quest);
        this.amount = this.list.size();
    }

    private Configuration getStartConfiguration() {
        return new Configuration(this.isChecking);
    }

    public int movesAmount() {
        return this.list.size();
    }

    public boolean takeBackMove() {
        if (this.amount > 1) {
            --this.amount;
            return true;
        }
        return false;
    }

    public boolean RedoLastMove() {
        if (this.list.size() > this.amount) {
            ++this.amount;
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.lastConf().getStatus();
    }

    private Configuration lastConf() {
        while (this.amount > 7) {
            this.list.removeElementAt(0);
            --this.amount;
        }
        return (Configuration)this.list.elementAt(this.amount - 1);
    }

    public Stone getStone(Coordinate c) {
        return this.lastConf().getStone(c);
    }

    public int getCurColor() {
        return this.lastConf().getCurColor();
    }

    public Vector getMoveList(Coordinate c) {
        Vector list = this.lastConf().getMoveList(c);
        return this.lastConf().getMoveList(c);
    }

    public boolean setMove(Move move) {
        Configuration newConf = this.lastConf().setMove(move);
        if (newConf == null) {
            return false;
        }
        while (this.amount < this.list.size()) {
            this.list.removeElementAt(this.list.size() - 1);
        }
        this.list.addElement(newConf);
        ++this.amount;
        return true;
    }
}

