/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.AttackMap;
import chess.BoardMap;
import chess.Coordinate;
import chess.Enviroment;
import chess.InfoMap;
import chess.Move;
import chess.MoveMap;
import chess.QuestionInterface;
import chess.Stone;
import chess.StoneBishop;
import chess.StoneHorse;
import chess.StoneKing;
import chess.StonePeon;
import chess.StoneQueen;
import chess.StoneRook;
import java.util.Vector;

public class Configuration
extends Enviroment {
    private BoardMap board;
    private InfoMap info;
    private AttackMap attack;
    private MoveMap moves;
    private int curColor;
    private int status = 0;
    private static QuestionInterface quest;
    private static boolean isChecking;

    public static void setQuestionObj(QuestionInterface _quest) {
        quest = _quest;
    }

    public Configuration(boolean isChecking) {
        Stone.setChecking(isChecking);
        Configuration.isChecking = isChecking;
        this.curColor = -1;
        this.board = BoardMap.createInitBoardMap();
        this.info = InfoMap.createInitInfoMap();
        this.attack = new AttackMap(this.board, this.curColor * -1);
        this.moves = new MoveMap(this);
    }

    public Configuration(BoardMap board, InfoMap info, int curColor, boolean isMoveMapNeeded) {
        this.curColor = curColor;
        this.board = board;
        this.info = info;
        if (isMoveMapNeeded) {
            this.calcStatus();
        }
    }

    public void calcStatus() {
        this.attack = new AttackMap(this.board, this.curColor * -1);
        if (this.attack.isGettingCheck()) {
            this.status = 5;
        }
        Stone.setChecking(true);
        this.moves = new MoveMap(this);
        Stone.setChecking(isChecking);
        if (!this.moves.isMovePossible()) {
            this.status = this.status == 5 ? 1 : 2;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Stone getStone(Coordinate c) {
        return this.board.getStone(c);
    }

    public int getCurColor() {
        return this.curColor;
    }

    public Vector getMoveList(Coordinate c) {
        return this.moves.getMoveList(c, this);
    }

    public Configuration setMove(Move move) {
        return this.setMove(move, true);
    }

    public Configuration setMove(Move move, boolean isMoveMapNeeded) {
        Configuration newConf;
        int newCurColor = this.curColor * -1;
        BoardMap newBoard = this.board.setMove(move);
        InfoMap newInfo = this.info.setMove(move);
        if (this.board.getStone(move.getSource()) instanceof StoneKing && Math.abs(move.getSource().getY() - move.getTarget().getY()) == 2) {
            Coordinate from;
            if (move.getTarget().getY() == 2) {
                from = new Coordinate(move.getSource().getX(), 0);
                Coordinate to = new Coordinate(move.getSource().getX(), 3);
                Move rookMove = new Move(from, to);
                newBoard = newBoard.setMove(rookMove);
                newInfo = newInfo.setMove(rookMove);
            } else {
                from = new Coordinate(move.getSource().getX(), 7);
                Coordinate to = new Coordinate(move.getSource().getX(), 5);
                Move rookMove = new Move(from, to);
                newBoard = newBoard.setMove(rookMove);
                newInfo = newInfo.setMove(rookMove);
            }
        }
        if (this.board.getStone(move.getSource()) instanceof StonePeon) {
            Coordinate x;
            if (this.isPeon2StepAllowed(move)) {
                x = move.getSource().getNewPos(this.getCurColor(), 0);
                newInfo.setInfo(2, x);
            }
            if (this.info.getInfo(move.getTarget()) == 2) {
                x = new Coordinate(move.getSource().getX(), move.getTarget().getY());
                newBoard.setStone(null, x);
            }
        }
        if (new AttackMap((newConf = new Configuration(newBoard, newInfo, newCurColor, isMoveMapNeeded)).getBoardMap(), this.getCurColor() * -1).isGettingCheck()) {
            return null;
        }
        if (this.board.getStone(move.getSource()) instanceof StonePeon && (move.getTarget().getX() == 7 || move.getTarget().getX() == 0) && isMoveMapNeeded) {
            this.changePeonTo(newConf, move.getTarget());
        }
        return newConf;
    }

    public BoardMap getBoardMap() {
        return this.board;
    }

    public InfoMap getInfoMap() {
        return this.info;
    }

    public AttackMap getAttackMap() {
        return this.attack;
    }

    public boolean isPeon2StepAllowed(Move move) {
        return this.board.isInBoardBorders(move.getTarget()) && this.info.getInfo(move.getSource()) == 1 && this.board.getStone(move.getTarget()) == null;
    }

    public void changePeonTo(Configuration conf, Coordinate target) {
        Object[] possibleValues = new Object[]{new StoneQueen(this.getCurColor()), new StoneRook(this.getCurColor()), new StoneBishop(this.getCurColor()), new StoneHorse(this.getCurColor())};
        quest.changePeonTo(possibleValues, conf, target);
    }

    static {
        isChecking = true;
    }
}

