/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.Coordinate;
import chess.Enviroment;
import chess.Move;
import chess.Stone;
import chess.StoneBishop;
import chess.StoneHorse;
import chess.StoneKing;
import chess.StonePeon;
import chess.StoneQueen;
import chess.StoneRook;

public class BoardMap
extends Enviroment {
    private Stone[][] board = new Stone[8][8];

    public static BoardMap createInitBoardMap() {
        BoardMap b = new BoardMap();
        for (int j = 0; j < 2; ++j) {
            int peonRow;
            int othersRow;
            int color;
            if (j == 0) {
                color = -1;
                othersRow = 7;
                peonRow = 6;
            } else {
                color = 1;
                othersRow = 0;
                peonRow = 1;
            }
            for (int i = 0; i < 8; ++i) {
                b.setStone(new StonePeon(color), new Coordinate(peonRow, i));
            }
            b.setStone(new StoneRook(color), new Coordinate(othersRow, 0));
            b.setStone(new StoneHorse(color), new Coordinate(othersRow, 1));
            b.setStone(new StoneBishop(color), new Coordinate(othersRow, 2));
            b.setStone(new StoneQueen(color), new Coordinate(othersRow, 3));
            b.setStone(new StoneKing(color), new Coordinate(othersRow, 4));
            b.setStone(new StoneBishop(color), new Coordinate(othersRow, 5));
            b.setStone(new StoneHorse(color), new Coordinate(othersRow, 6));
            b.setStone(new StoneRook(color), new Coordinate(othersRow, 7));
        }
        return b;
    }

    public BoardMap setMove(Move move) {
        BoardMap b = new BoardMap();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Coordinate c = new Coordinate(i, j);
                b.setStone(this.getStone(c), c);
            }
        }
        Stone stone = this.getStone(move.getSource());
        b.setStone(stone, move.getTarget());
        b.setStone(null, move.getSource());
        return b;
    }

    public void setStone(Stone stone, Coordinate c) {
        this.board[c.getX()][c.getY()] = stone;
    }

    public Stone getStone(Coordinate c) {
        return this.board[c.getX()][c.getY()];
    }

    public boolean isNotSameColor(Coordinate c, int color) {
        if (this.getStone(c) == null) {
            return true;
        }
        return this.getStone(c).getColor() != color;
    }

    public boolean isInBoardBorders(Coordinate c) {
        if (c.getX() < 0) {
            return false;
        }
        if (c.getY() < 0) {
            return false;
        }
        if (c.getX() > 7) {
            return false;
        }
        return c.getY() <= 7;
    }
}

