/*
 * Decompiled with CFR 0.152.
 */
package chess;

import chess.BoardMap;
import chess.Coordinate;
import chess.Enviroment;
import chess.Stone;
import chess.StoneKing;
import java.util.Enumeration;
import java.util.Vector;

public class AttackMap
extends Enviroment {
    int[][] attack = new int[8][8];
    private Coordinate kingPos = new Coordinate(0, 0);

    public AttackMap(BoardMap board, int attackerColor) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Coordinate c = new Coordinate(i, j);
                Stone stone = board.getStone(c);
                if (stone == null) continue;
                if (stone.getColor() == attackerColor) {
                    this.registerAttackList(stone.getAttackList(c, board));
                    continue;
                }
                if (!(stone instanceof StoneKing)) continue;
                this.kingPos = c;
            }
        }
    }

    public boolean isUnderAttack(Coordinate c) {
        return this.attack[c.getX()][c.getY()] != 0;
    }

    public boolean isGettingCheck() {
        return this.attack[this.kingPos.getX()][this.kingPos.getY()] != 0;
    }

    private void registerAttackList(Vector list) {
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            Coordinate c = (Coordinate)enumeration.nextElement();
            int[] nArray = this.attack[c.getX()];
            int n = c.getY();
            nArray[n] = nArray[n] + 1;
        }
    }
}

